/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.util.Optional;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.api.MandatoryService;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.LabeledField;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

abstract class PositiveIntField
extends LabeledField<Integer> {
    private final String name;
    private Spinner spinner;

    PositiveIntField(int origin, String name, Runnable modified, LabelProvider labels, MandatoryService context) {
        super(Optional.of(origin), modified, labels, context);
        this.name = name;
    }

    @Override
    protected final String label() {
        return this.name;
    }

    @Override
    protected final Control control(Composite parent) {
        this.spinner = new Spinner(parent, 2048);
        this.spinner.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.spinner.setMinimum(1);
        this.spinner.setIncrement(1);
        this.spinner.setPageIncrement(10);
        this.spinner.setMaximum(Integer.MAX_VALUE);
        this.spinner.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.installData(Optional.of(this.spinner.getSelection()))));
        return this.spinner;
    }

    @Override
    protected final void reflectData(Integer data) {
        this.spinner.setSelection(data.intValue());
    }

    @Override
    public final Optional<String> error() {
        Optional current = this.data();
        if (!current.isPresent()) {
            return Optional.of(this.errorText());
        }
        if (this.candidateIsValid((Integer)current.get())) {
            return Optional.empty();
        }
        return Optional.of(this.errorText());
    }

    @Override
    protected void enableAuxiliaryControls(boolean enable) {
    }

    private boolean candidateIsValid(int candidate) {
        return candidate > 0;
    }

    protected abstract String errorText();
}

