/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workspace;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.api.workspace.ResourceType;
import org.eclipse.passage.loc.workspace.LocalFileHandle;

public final class LoadResourceSet {
    private final Supplier<Path> base;
    private final String domain;
    private final ResourceType type;

    public LoadResourceSet(ResourceType type, Supplier<Path> path, String domain) {
        this.base = Objects.requireNonNull(path);
        this.domain = Objects.requireNonNull(domain);
        this.type = Objects.requireNonNull(type);
    }

    public List<ResourceHandle> load() {
        try {
            Path parent = this.base.get();
            Files.createDirectories(parent, new FileAttribute[0]);
            Path path = parent.resolve(this.domain);
            if (!Files.exists(path, new LinkOption[0])) {
                return Collections.emptyList();
            }
            return Files.readAllLines(path).stream().map(string -> Paths.get(string, new String[0])).map(p -> new LocalFileHandle(this.type, path)).collect(Collectors.toList());
        }
        catch (Exception e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }
}

