/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.licenses.PersonalLicensePackDescriptor;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.loc.internal.agreements.AgreementRegistry;
import org.eclipse.passage.loc.internal.api.FloatingLicenseRequest;
import org.eclipse.passage.loc.internal.api.IssuedFloatingLicense;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;
import org.eclipse.passage.loc.internal.equinox.OperatorProductService;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.FloatingLicensePackFromRequest;
import org.eclipse.passage.loc.internal.licenses.core.IssueFloatingLicense;
import org.eclipse.passage.loc.internal.licenses.core.IssuePersonalLicense;
import org.eclipse.passage.loc.internal.licenses.core.PersonalLicensePackFromRequest;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component
public class LicenseOperatorServiceImpl
implements OperatorLicenseService {
    private EnvironmentInfo environmentInfo;
    private EventAdmin events;
    private ProductRegistry products;
    private UserRegistry users;
    private LicenseRegistry licenses;
    private AgreementRegistry agreements;
    private OperatorProductService operator;

    @Reference
    public void bindEnvironmentInfo(EnvironmentInfo environment) {
        this.environmentInfo = environment;
    }

    public void unbindEnvironmentInfo(EnvironmentInfo environment) {
        if (Objects.equals(this.environmentInfo, environment)) {
            this.environmentInfo = null;
        }
    }

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.events = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        if (Objects.equals(this.events, admin)) {
            this.events = null;
        }
    }

    @Reference
    public void bindProductRegistry(ProductRegistry registry) {
        this.products = registry;
    }

    public void unbindProductRegistry(ProductRegistry registry) {
        if (Objects.equals(this.products, registry)) {
            this.products = null;
        }
    }

    @Reference
    public void bindLicenseRegistry(LicenseRegistry registry) {
        this.licenses = registry;
    }

    public void unbindLicenseRegistry(LicenseRegistry registry) {
        if (Objects.equals(this.licenses, registry)) {
            this.licenses = null;
        }
    }

    @Reference
    public void bindAgreementRegistry(AgreementRegistry registry) {
        this.agreements = registry;
    }

    public void unbindAgreementRegistry(AgreementRegistry registry) {
        if (Objects.equals(this.agreements, registry)) {
            this.agreements = null;
        }
    }

    @Reference
    public void bindUserRegistry(UserRegistry registry) {
        this.users = registry;
    }

    public void unbindUserRegistry(UserRegistry registry) {
        if (Objects.equals(this.users, registry)) {
            this.users = null;
        }
    }

    @Reference
    public void bindProductOperatorService(OperatorProductService productService) {
        this.operator = productService;
    }

    public void unbindProductOperatorService(OperatorProductService productService) {
        if (Objects.equals(this.operator, productService)) {
            this.operator = null;
        }
    }

    public PersonalLicensePack createLicensePack(PersonalLicenseRequest request) {
        return new PersonalLicensePackFromRequest(request, this.licenses).get();
    }

    public ServiceInvocationResult<IssuedLicense> issueLicensePack(PersonalLicenseRequest request, PersonalLicensePackDescriptor template) {
        Objects.requireNonNull(request, "LicenseOperatorServiceImpl::issueLicensePack: cannot issue license for null request");
        Supplier<PersonalLicensePack> pack = template instanceof PersonalLicensePack ? () -> (PersonalLicensePack)PersonalLicensePack.class.cast(template) : () -> this.createLicensePack(request);
        return new IssuePersonalLicense(this.licenses, this.agreements, this.products, this.operator, this.events).issue(pack);
    }

    public FloatingLicensePack createFloatingLicensePack(FloatingLicenseRequest request, Optional<FloatingLicensePack> template) {
        return new FloatingLicensePackFromRequest(request, template, this.licenses, this.users).get();
    }

    public ServiceInvocationResult<IssuedFloatingLicense> issueFloatingLicensePack(FloatingLicensePack pack, Collection<FloatingLicenseAccess> configs) {
        Objects.requireNonNull(pack, "LicenseOperatorServiceImpl::issueFloatingLicensePack: cannot issue license over no data");
        Objects.requireNonNull(configs, "LicenseOperatorServiceImpl::configs");
        return new IssueFloatingLicense(this.licenses, this.agreements, this.products, this.operator).issue(pack, configs);
    }
}

