/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.email.Mailing;
import org.eclipse.passage.lic.licenses.PersonalLicensePackDescriptor;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.internal.licenses.core.EmailTemplate;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IssueLicenseDetailsPage
extends WizardPage {
    private final IEclipseContext context;
    private final Supplier<PersonalLicensePackDescriptor> data;
    private Text info;
    private Text from;
    private String mailFrom = "";

    protected IssueLicenseDetailsPage(String pageName, Supplier<PersonalLicensePackDescriptor> data, IEclipseContext context) {
        super(pageName);
        this.context = context;
        this.data = data;
        this.setTitle(IssueLicensePageMessages.IssueLicenseDetailsPage_page_title);
        this.setDescription(IssueLicensePageMessages.IssueLicenseDetailsPage_page_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        composite.setLayout((Layout)new GridLayout());
        this.info = new Text(composite, 2114);
        this.info.setLayoutData((Object)new GridData(4, 4, true, true));
        Optional.ofNullable((Mailing)this.context.get(Mailing.class)).ifPresent(m -> this.createEmlButton(composite));
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void createEmlButton(Composite parent) {
        Group prepareEml = new Group(parent, 32);
        prepareEml.setLayoutData((Object)new GridData(4, 4, false, false));
        prepareEml.setText(IssueLicensePageMessages.IssueLicenseDetailsPage_lbl_eml_text);
        prepareEml.setLayout((Layout)new GridLayout());
        this.from = new Text((Composite)prepareEml, 0);
        this.from.setLayoutData((Object)new GridData(4, 4, true, false));
        this.from.addModifyListener(e -> {
            String string = this.mailFrom = this.from.getText().trim();
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.info == null || this.info.isDisposed()) {
                return;
            }
            Mailing mailing = (Mailing)this.context.get(Mailing.class);
            if (mailing == null) {
                return;
            }
            this.info.setText(new EmailTemplate(mailing).details(this.data.get()).stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    public String mailFrom() {
        return this.mailFrom;
    }
}

