/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.util.Optional;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.api.MandatoryService;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Field;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

abstract class LabeledField<T>
implements Field<T> {
    protected final Optional<T> source;
    protected final Runnable modified;
    protected final LabelProvider labels;
    protected final MandatoryService context;
    private Optional<Control> widget = Optional.empty();
    private Shell shell;
    private Label label;

    protected LabeledField(Optional<T> source, Runnable modified, LabelProvider labels, MandatoryService context) {
        this.source = source;
        this.modified = modified;
        this.labels = labels;
        this.context = context;
    }

    @Override
    public final void installControll(Composite parent) {
        this.shell = parent.getShell();
        this.installLabel(parent);
        this.widget = Optional.of(this.control(parent));
        this.installData(this.source);
    }

    @Override
    public final Optional<T> data() {
        return this.widget.flatMap(w -> Optional.ofNullable(w.getData()));
    }

    private void installLabel(Composite parent) {
        this.label = new Label(parent, 0);
        this.label.setText(this.label());
        this.label.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    protected final void installData(Optional<T> origin) {
        Object data = origin.orElse(null);
        this.widget.ifPresent(w -> w.setData(data));
        this.reflectData(data);
    }

    protected final Optional<T> source() {
        return this.source;
    }

    protected final Shell shell() {
        return this.shell;
    }

    @Override
    public final Optional<String> errorIfAny() {
        boolean enabled = this.widget.map(Control::isEnabled).orElse(false);
        return enabled ? this.error() : Optional.empty();
    }

    @Override
    public final void enable(boolean enable) {
        this.label.setEnabled(enable);
        this.widget.ifPresent(w -> w.setEnabled(enable));
        this.enableAuxiliaryControls(enable);
    }

    protected abstract String label();

    protected abstract Control control(Composite var1);

    protected abstract void reflectData(T var1);

    protected abstract Optional<String> error();

    protected abstract void enableAuxiliaryControls(boolean var1);
}

