/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench.wizards;

import java.io.IOException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.passage.lic.api.MandatoryService;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.emf.meta.ComposableClassMetadata;
import org.eclipse.passage.lic.emf.meta.EntityMetadata;
import org.eclipse.passage.lic.emf.resource.ResourceSaveFailed;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.workbench.SelectRequest;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.internal.workbench.wizards.BaseClassifierWizard;
import org.eclipse.passage.loc.internal.workbench.wizards.InnerClassifierWizardPage;

public final class InnerClassifierWizard<I, R>
extends BaseClassifierWizard<InnerClassifierWizardPage<R>> {
    private final Class<I> clazz;
    private final MandatoryService context;
    private final SelectRequest<R> request;

    public InnerClassifierWizard(Class<I> clazz, EntityMetadata metadata, EditingDomainRegistry<?> registry, SelectRequest<R> request, MandatoryService context) {
        super(metadata, registry);
        this.clazz = clazz;
        this.request = request;
        this.context = context;
    }

    @Override
    protected InnerClassifierWizardPage<R> createNewClassifierPage() {
        Optional find = ((ComposableClassMetadata)this.context.get(ComposableClassMetadata.class)).find(this.clazz);
        if (find.isPresent()) {
            return new InnerClassifierWizardPage<R>((EntityMetadata)find.get(), this.request, this.context);
        }
        throw new NoSuchElementException(this.clazz.getName());
    }

    @Override
    protected ServiceInvocationResult<Boolean> store() {
        return this.store(((InnerClassifierWizardPage)this.newClassifierPage).container(), ((InnerClassifierWizardPage)this.newClassifierPage).candidate());
    }

    protected ServiceInvocationResult<Boolean> store(Optional<R> container, EObject candidate) {
        if (!container.isPresent()) {
            return new BaseServiceInvocationResult((Object)Boolean.FALSE);
        }
        EReference reference = this.containerEReference(candidate.eClass()).get();
        candidate.eSet((EStructuralFeature)reference, container.get());
        Resource resource = candidate.eResource();
        if (resource == null) {
            return new BaseServiceInvocationResult((Object)Boolean.FALSE);
        }
        try {
            resource.save(new HashMap());
            return new BaseServiceInvocationResult((Object)Boolean.TRUE);
        }
        catch (IOException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ResourceSaveFailed(), WorkbenchMessages.InnerClassifierWizard_e_store, (Exception)e));
        }
    }

    private Optional<EReference> containerEReference(EClass eClass) {
        return eClass.getEAllReferences().stream().filter(EReference::isContainer).findFirst();
    }
}

