/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.passage.lic.runtime.io.StreamCodec;

public class NullStreamCodec
implements StreamCodec {
    public static final NullStreamCodec INSTANCE = new NullStreamCodec();

    public String getKeyAlgo() {
        return String.valueOf(null);
    }

    public int getKeySize() {
        return 0;
    }

    public void createKeyPair(String publicKeyPath, String privateKeyPath, String username, String password) throws IOException {
        Files.createFile(Paths.get(publicKeyPath, new String[0]), new FileAttribute[0]);
        Files.createFile(Paths.get(privateKeyPath, new String[0]), new FileAttribute[0]);
    }

    public void encodeStream(InputStream input, OutputStream output, InputStream key, String username, String password) throws IOException {
        NullStreamCodec.transfer(input, output);
    }

    public Object decodeStream(InputStream input, OutputStream output, InputStream key, byte[] digest) throws IOException {
        NullStreamCodec.transfer(input, output);
        return null;
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }
}

