/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.ParseUtil;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static List<String> readFile(String filename) {
        return FileUtil.readFile(filename, true);
    }

    public static List<String> readFile(String filename, boolean reportError) {
        if (new File(filename).canRead()) {
            LOG.debug("Reading file {}", (Object)filename);
            try {
                return Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                if (reportError) {
                    LOG.error("Error reading file {}. {}", (Object)filename, (Object)e);
                }
            }
        } else if (reportError) {
            LOG.warn("File not found or not readable: {}", (Object)filename);
        }
        return new ArrayList<String>();
    }

    public static long getLongFromFile(String filename) {
        LOG.debug("Reading file {}", (Object)filename);
        List<String> read = FileUtil.readFile(filename, false);
        if (!read.isEmpty()) {
            LOG.trace("Read {}", (Object)read.get(0));
            return ParseUtil.parseLongOrDefault(read.get(0), 0L);
        }
        return 0L;
    }

    public static long getUnsignedLongFromFile(String filename) {
        LOG.debug("Reading file {}", (Object)filename);
        List<String> read = FileUtil.readFile(filename, false);
        if (!read.isEmpty()) {
            LOG.trace("Read {}", (Object)read.get(0));
            return ParseUtil.parseUnsignedLongOrDefault(read.get(0), 0L);
        }
        return 0L;
    }

    public static int getIntFromFile(String filename) {
        LOG.debug("Reading file {}", (Object)filename);
        try {
            List<String> read = FileUtil.readFile(filename, false);
            if (!read.isEmpty()) {
                LOG.trace("Read {}", (Object)read.get(0));
                return Integer.parseInt(read.get(0));
            }
        }
        catch (NumberFormatException ex) {
            LOG.debug("Unable to read value from {}. {}", (Object)filename, (Object)ex);
        }
        return 0;
    }

    public static String getStringFromFile(String filename) {
        LOG.debug("Reading file {}", (Object)filename);
        List<String> read = FileUtil.readFile(filename, false);
        if (!read.isEmpty()) {
            LOG.trace("Read {}", (Object)read.get(0));
            return read.get(0);
        }
        return "";
    }

    public static Map<String, String> getKeyValueMapFromFile(String filename, String separator) {
        HashMap<String, String> map = new HashMap<String, String>();
        LOG.debug("Reading file {}", (Object)filename);
        List<String> lines = FileUtil.readFile(filename, false);
        for (String line : lines) {
            String[] parts = line.split(separator);
            if (parts.length != 2) continue;
            map.put(parts[0], parts[1].trim());
        }
        return map;
    }
}

