/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.inspection.RuntimeEnvironment;
import org.eclipse.passage.lic.equinox.Environments;
import org.eclipse.passage.lic.internal.jetty.interaction.Command;
import org.eclipse.passage.lic.internal.jetty.interaction.Scope;

final class LicenseRequest
extends Command {
    public LicenseRequest() {
        super((Scope)new Scope.Self(), (List<String>)new LicRequest().get());
    }

    public void licrequest() {
        Collection envs = new Environments().get();
        this.reportEnvironmentsDiscovered(envs);
        for (RuntimeEnvironment env : envs) {
            try {
                this.reportAssessment(env);
            }
            catch (LicensingException e) {
                System.err.printf("%s environment assessment failed\n", ((EvaluationType)env.id()).identifier());
                e.printStackTrace();
            }
        }
    }

    private void reportEnvironmentsDiscovered(Collection<RuntimeEnvironment> envs) {
        System.out.printf("\nTo request a license send demanded particles of these %d environments (%s) assessment to your licensing operator:\n", envs.size(), envs.stream().map(env -> ((EvaluationType)env.id()).identifier()).collect(Collectors.joining(", ")));
    }

    private void reportAssessment(RuntimeEnvironment env) throws LicensingException {
        System.out.printf("\n==== %s ====\n%s\n", ((EvaluationType)env.id()).identifier(), env.state());
    }

    @Override
    protected List<String> commands() {
        return new LicRequest().get();
    }

    @Override
    public String usage() {
        return "Start environment assessment to gather information demanded for license issuing";
    }

    private static final class LicRequest
    extends Command.Name {
        protected LicRequest() {
            super("licrequest");
        }
    }
}

