/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.diagnostic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;

public final class BaseDiagnostic
implements Diagnostic {
    private final List<Trouble> severe;
    private final List<Trouble> bearable;

    public BaseDiagnostic() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public BaseDiagnostic(Trouble severe) {
        this(Collections.singletonList(severe), Collections.emptyList());
    }

    public BaseDiagnostic(Trouble severe, List<Trouble> bearable) {
        this(Collections.singletonList(severe), bearable);
    }

    public BaseDiagnostic(List<Trouble> bearable) {
        this(Collections.emptyList(), bearable);
        if (bearable.isEmpty()) {
            throw new IllegalArgumentException("Diagnostic is not useful without any information");
        }
    }

    public BaseDiagnostic(List<Trouble> severe, List<Trouble> bearable) {
        Objects.requireNonNull(severe, "BaseDiagnostic:severe");
        Objects.requireNonNull(bearable, "BaseDiagnostic:bearable");
        this.severe = severe;
        this.bearable = bearable;
    }

    public List<Trouble> severe() {
        return this.severe;
    }

    public List<Trouble> bearable() {
        return this.bearable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Trouble trouble : this.severe) {
            builder.append(trouble.details()).append('\n');
        }
        for (Trouble trouble : this.bearable) {
            builder.append(trouble.details()).append('\n');
        }
        return builder.toString();
    }
}

