/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.internal.transform.serial.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IModelReader;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IRWUserBasedRes;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.R4EReader;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TResReader
extends R4EReader
implements IModelReader {
    public <T> T deserializeTopElement(URI aRootPath, ResourceSet resSet, Class<T> type) throws ResourceHandlingException {
        if (aRootPath == null) {
            return null;
        }
        EList<EObject> eObjects = this.getObjects(aRootPath, resSet);
        return this.findType(type, eObjects);
    }

    private <T> T findType(Class<T> type, EList<EObject> eObjects) {
        EObject element = null;
        for (EObject eobject : eObjects) {
            if (!type.isAssignableFrom(eobject.getClass())) continue;
            element = eobject;
            break;
        }
        return (T)element;
    }

    private EList<EObject> getObjects(URI resourcePath) throws ResourceHandlingException {
        Resource resource = this.createResourceSetWithResource(resourcePath);
        return this.getObjects(resourcePath, resource);
    }

    private EList<EObject> getObjects(URI resourcePath, ResourceSet resSet) throws ResourceHandlingException {
        Resource resource = this.createResource(resourcePath, resSet);
        return this.getObjects(resourcePath, resource);
    }

    private EList<EObject> getObjects(URI resourcePath, Resource resource) throws ResourceHandlingException {
        try {
            resource.load(null);
        }
        catch (IOException e) {
            String message = new StringBuffer("Unable to load resource at URI: " + resourcePath.toString()).toString();
            ResourceHandlingException exception = new ResourceHandlingException(message, (Throwable)e);
            throw exception;
        }
        EList eObjects = resource.getContents();
        return eObjects;
    }

    public void reloadResource(Resource resource) throws ResourceHandlingException {
        if (resource == null) {
            return;
        }
        try {
            resource.load(this.fOptions);
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder("Unable to load resource");
            URI resURI = resource.getURI();
            if (resURI != null) {
                sb.append(": " + resource.getURI().toString());
            }
            throw new ResourceHandlingException(sb.toString(), (Throwable)e);
        }
    }

    public List<URI> selectUsrReviewGroupRes(URI aFolder) {
        return this.selectFiles(aFolder, IRWUserBasedRes.USER_GROUP_REVS_PATT);
    }

    public List<URI> selectUsrCommentsRes(URI aFolder) {
        return this.selectFiles(aFolder, IRWUserBasedRes.USER_COMMENTS_PATT);
    }

    public List<URI> selectUsrItemsRes(URI aFolder) {
        return this.selectFiles(aFolder, IRWUserBasedRes.USER_ITEMS_PATT);
    }

    public Boolean isGroupResourceUri(URI uri) {
        return this.uriMatch(uri, IRWUserBasedRes.ROOT_GROUP_PATT);
    }

    private List<URI> selectFiles(URI aFolder, Pattern pattern) {
        Matcher matcher = null;
        ArrayList<URI> filesRes = new ArrayList<URI>();
        String path = URI.decode((String)aFolder.devicePath());
        File folder = new File(path);
        if (folder.exists()) {
            String[] files;
            String[] stringArray = files = folder.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                matcher = pattern.matcher(file);
                if (matcher.find()) {
                    filesRes.add(aFolder.appendSegment(file));
                }
                ++n2;
            }
        }
        return filesRes;
    }

    private Boolean uriMatch(URI uri, Pattern pattern) {
        if (uri == null || pattern == null) {
            return null;
        }
        String uriStr = uri.toString();
        Matcher matcher = pattern.matcher(uriStr);
        if (matcher.find()) {
            return true;
        }
        return false;
    }

    private Resource createResource(URI aPathToResource, ResourceSet resourceSet) {
        Resource groupResource = null;
        if (aPathToResource != null && resourceSet != null) {
            groupResource = resourceSet.getResource(aPathToResource, true);
        }
        return groupResource;
    }
}

