/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.io.FileNotFoundException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Opening Element...";

    public Object execute(final ExecutionEvent aEvent) {
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object aFamily) {
                return this.familyName.equals(aFamily);
            }

            public IStatus run(IProgressMonitor aMonitor) {
                aMonitor.beginTask(OpenElementHandler.COMMAND_MESSAGE, -1);
                R4EUIModelController.setJobInProgress(true);
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)aEvent);
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    IR4EUIModelElement element = null;
                    try {
                        element = (IR4EUIModelElement)((IStructuredSelection)selection).getFirstElement();
                        if (element instanceof R4EUIReviewBasic) {
                            R4EUIPlugin.Ftracer.traceInfo("Opening element " + element.getName());
                            R4EUIReviewBasic activeReview = R4EUIModelController.getActiveReview();
                            if (activeReview != null) {
                                activeReview.close();
                            }
                            R4EUIModelController.resetToDefaultSerialization();
                        }
                        element.open();
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(element, 1);
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                        if (element != null && element instanceof R4EUIReviewBasic) {
                            element.close();
                        }
                    }
                    catch (CompatibilityException e) {
                        UIUtils.displayCompatibilityErrorDialog(e);
                        if (element != null && element instanceof R4EUIReviewBasic) {
                            element.close();
                        }
                    }
                    catch (FileNotFoundException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
                        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "File not found error detected while opening element", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                dialog.open();
                            }
                        });
                    }
                }
                R4EUIModelController.setJobInProgress(false);
                aMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

