/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class R4EUIFileContainer
extends R4EUIModelElement {
    protected final int fType;
    protected final R4EItem fItem;
    protected final List<R4EUIFileContext> fFileContexts;

    protected R4EUIFileContainer(IR4EUIModelElement aParent, R4EItem aItem, String aName, int aItemType) {
        super(aParent, aName);
        this.fReadOnly = aParent.isReadOnly();
        this.fItem = aItem;
        this.fType = aItemType;
        this.fFileContexts = new ArrayList<R4EUIFileContext>();
    }

    @Override
    public String getToolTip() {
        return this.fItem.getDescription();
    }

    public R4EItem getItem() {
        return this.fItem;
    }

    public List<R4EUIFileContext> getFileContexts() {
        return this.fFileContexts;
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fItem, R4EUIModelController.getReviewer());
        this.fItem.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        for (R4EUIFileContext file : this.fFileContexts) {
            file.setEnabled(true);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.fItem.isEnabled();
    }

    @Override
    public void close() {
        R4EUIFileContext fileContext = null;
        int fileContextsSize = this.fFileContexts.size();
        int i = 0;
        while (i < fileContextsSize) {
            fileContext = this.fFileContexts.get(i);
            fileContext.close();
            ++i;
        }
        this.fFileContexts.clear();
        this.fOpen = false;
    }

    @Override
    public void open() {
        EList files = this.fItem.getFileContextList();
        if (files != null) {
            R4EUIFileContext uiFileContext = null;
            int filesSize = files.size();
            R4EFileContext file = null;
            int i = 0;
            while (i < filesSize) {
                file = (R4EFileContext)files.get(i);
                if (file.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                    uiFileContext = new R4EUIFileContext(this, (R4EFileContext)files.get(i), this.fType);
                    this.addChildren(uiFileContext);
                    if (uiFileContext.isEnabled()) {
                        uiFileContext.open();
                    }
                }
                ++i;
            }
        }
        this.fOpen = true;
    }

    public void verifyUserReviewed() {
        try {
            R4EUIReviewBasic review = (R4EUIReviewBasic)this.getParent();
            R4EParticipant user = review.getParticipant(R4EUIModelController.getReviewer(), false);
            if (user != null) {
                for (R4EUIFileContext uiFile : this.fFileContexts) {
                    uiFile.verifyUserReviewed();
                    if (!user.getReviewedContent().contains((Object)uiFile.getFileContext().getId())) continue;
                    uiFile.setUserReviewed(true, true, false);
                }
            }
        }
        catch (ResourceHandlingException e) {
            UIUtils.displayResourceErrorDialog(e);
        }
        catch (OutOfSyncException e) {
            UIUtils.displaySyncErrorDialog(e);
        }
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fFileContexts.toArray(new R4EUIFileContext[this.fFileContexts.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.fFileContexts.size() > 0;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fFileContexts.add((R4EUIFileContext)aChildToAdd);
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIFileContext removedElement = this.fFileContexts.get(this.fFileContexts.indexOf(aChildToRemove));
        removedElement.removeAllChildren(aFileRemove);
        R4EFileContext modelFile = removedElement.getFileContext();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelFile, R4EUIModelController.getReviewer());
        modelFile.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fFileContexts.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIFileContext file : this.fFileContexts) {
            this.removeChildren(file, aFileRemove);
        }
    }
}

