/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.DRModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleCollection;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IReviewGroupInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IRuleSetInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIRootElement
extends R4EUIModelElement {
    private final List<R4EUIReviewGroup> fReviewGroups = new ArrayList<R4EUIReviewGroup>();
    private final List<R4EUIRuleSet> fRuleSets = new ArrayList<R4EUIRuleSet>();

    public R4EUIRootElement(IR4EUIModelElement aParent, String aName) {
        super(aParent, aName);
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempReviewGroups = new ArrayList<ReviewComponent>();
        IReviewGroupInputDialog dialog = R4EUIDialogFactory.getInstance().getReviewGroupInputDialog();
        dialog.create();
        int result = dialog.open();
        if (result == 0) {
            R4EReviewGroup tempReviewGroup = RModelFactory.eINSTANCE.createR4EReviewGroup();
            tempReviewGroup.setName(dialog.getGroupNameValue());
            tempReviewGroup.setDescription(dialog.getGroupDescriptionValue());
            tempReviewGroup.setFolder(dialog.getGroupFolderValue());
            String[] stringArray = dialog.getAvailableProjectsValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String project = stringArray[n2];
                tempReviewGroup.getAvailableProjects().add((Object)project);
                ++n2;
            }
            stringArray = dialog.getAvailableComponentsValues();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                tempReviewGroup.getAvailableComponents().add((Object)component);
                ++n2;
            }
            stringArray = dialog.getRuleSetValues();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String ruleSetLocation = stringArray[n2];
                tempReviewGroup.getDesignRuleLocations().add((Object)ruleSetLocation);
                ++n2;
            }
            tempReviewGroup.setDefaultEntryCriteria(dialog.getDefaultEntryCriteriaValue());
            tempReviewGroups.add((ReviewComponent)tempReviewGroup);
        }
        return tempReviewGroups;
    }

    public ReviewComponent createRuleSetElement() {
        R4EDesignRuleCollection tempRuleSet = null;
        IRuleSetInputDialog dialog = R4EUIDialogFactory.getInstance().getRuleSetInputDialog();
        dialog.create();
        int result = dialog.open();
        if (result == 0) {
            tempRuleSet = DRModelFactory.eINSTANCE.createR4EDesignRuleCollection();
            tempRuleSet.setVersion(dialog.getVersionValue());
            tempRuleSet.setFolder(dialog.getFolderValue());
            tempRuleSet.setName(dialog.getNameValue());
        }
        return tempRuleSet;
    }

    @Override
    public void close() {
        R4EUIReviewGroup reviewGroup = null;
        int reviewGroupsSize = this.fReviewGroups.size();
        int i = 0;
        while (i < reviewGroupsSize) {
            reviewGroup = this.fReviewGroups.get(i);
            if (reviewGroup.isOpen()) {
                reviewGroup.close();
            }
            ++i;
        }
        this.fReviewGroups.clear();
        R4EUIRuleSet ruleSet = null;
        int ruleSetSize = this.fRuleSets.size();
        int i2 = 0;
        while (i2 < ruleSetSize) {
            ruleSet = this.fRuleSets.get(i2);
            if (ruleSet.isOpen()) {
                ruleSet.close();
            }
            ++i2;
        }
        this.fRuleSets.clear();
        this.fOpen = false;
    }

    public List<R4EUIRuleSet> getRuleSets() {
        return this.fRuleSets;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        ArrayList<R4EUIModelElement> newList = new ArrayList<R4EUIModelElement>();
        for (R4EUIReviewGroup group : this.fReviewGroups) {
            newList.add(group);
        }
        for (R4EUIRuleSet ruleSet : this.fRuleSets) {
            newList.add(ruleSet);
        }
        return newList.toArray(new IR4EUIModelElement[newList.size()]);
    }

    public R4EUIReviewGroup[] getGroups() {
        return this.fReviewGroups.toArray(new R4EUIReviewGroup[this.fReviewGroups.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.fReviewGroups.size() != 0 || this.fRuleSets.size() != 0;
    }

    public void loadReviewGroup(R4EReviewGroup aGroup) {
        if (aGroup.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            R4EUIReviewGroup addedChild = new R4EUIReviewGroup(this, aGroup, false);
            this.addChildren(addedChild);
        }
    }

    public void loadRuleSet(R4EDesignRuleCollection aRuleSet) {
        if (aRuleSet.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            R4EUIRuleSet addedChild = new R4EUIRuleSet(this, aRuleSet, false);
            this.addChildren(addedChild);
            addedChild.close();
        }
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        if (aModelComponent instanceof R4EReviewGroup) {
            String[] prefGroups;
            String groupName = ((R4EReviewGroup)aModelComponent).getName();
            for (R4EUIReviewGroup group : this.fReviewGroups) {
                if (!group.getReviewGroup().getName().equals(groupName)) continue;
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Error while creating new Review Group ", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Review Group " + groupName + " already exists", null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
                return null;
            }
            R4EReviewGroup reviewGroup = R4EUIModelController.FModelExt.createR4EReviewGroup(URI.createFileURI((String)((R4EReviewGroup)aModelComponent).getFolder()), groupName);
            R4EUIReviewGroup addedChild = new R4EUIReviewGroup(this, reviewGroup, true);
            addedChild.setModelData(aModelComponent);
            this.addChildren(addedChild);
            IPreferenceStore preferenceStore = R4EUIPlugin.getDefault().getPreferenceStore();
            String newGroup = reviewGroup.eResource().getURI().toFileString();
            String prefGroupsStr = preferenceStore.getString("groupFilePathPreference");
            String[] stringArray = prefGroups = prefGroupsStr.split(R4EUIConstants.LINE_FEED);
            int n = prefGroups.length;
            int n2 = 0;
            while (n2 < n) {
                String prefGroup = stringArray[n2];
                if (prefGroup.equals(String.valueOf(newGroup) + ";")) {
                    return addedChild;
                }
                ++n2;
            }
            preferenceStore.setValue("groupFilePathPreference", String.valueOf(preferenceStore.getString("groupFilePathPreference")) + R4EUIConstants.LINE_FEED + newGroup);
            return addedChild;
        }
        if (aModelComponent instanceof R4EDesignRuleCollection) {
            String[] prefSets;
            R4EUIRuleSet ruleSet2;
            String ruleSetName = ((R4EDesignRuleCollection)aModelComponent).getName();
            for (R4EUIRuleSet ruleSet2 : this.fRuleSets) {
                if (!ruleSet2.getRuleSet().getName().equals(ruleSetName)) continue;
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Error while creating new Rule Set  ", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Rule Set " + ruleSetName + " already exists", null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
                return null;
            }
            ruleSet2 = R4EUIModelController.FModelExt.createR4EDesignRuleCollection(URI.createFileURI((String)((R4EDesignRuleCollection)aModelComponent).getFolder()), ruleSetName);
            R4EUIRuleSet addedChild = new R4EUIRuleSet(this, (R4EDesignRuleCollection)ruleSet2, true);
            addedChild.setModelData(aModelComponent);
            this.addChildren(addedChild);
            IPreferenceStore preferenceStore = R4EUIPlugin.getDefault().getPreferenceStore();
            String newSet = ruleSet2.eResource().getURI().toFileString();
            String prefSetsStr = preferenceStore.getString("ruleSetFilePathPreference");
            String[] stringArray = prefSets = prefSetsStr.split(R4EUIConstants.LINE_FEED);
            int n = prefSets.length;
            int n3 = 0;
            while (n3 < n) {
                String prefSet = stringArray[n3];
                if (prefSet.equals(newSet)) {
                    return addedChild;
                }
                ++n3;
            }
            preferenceStore.setValue("ruleSetFilePathPreference", String.valueOf(preferenceStore.getString("ruleSetFilePathPreference")) + R4EUIConstants.LINE_FEED + newSet);
            return addedChild;
        }
        return null;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        if (aChildToAdd instanceof R4EUIReviewGroup) {
            this.fReviewGroups.add((R4EUIReviewGroup)aChildToAdd);
        } else if (aChildToAdd instanceof R4EUIRuleSet) {
            this.fRuleSets.add((R4EUIRuleSet)aChildToAdd);
        } else {
            return;
        }
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        if (aChildToRemove instanceof R4EUIReviewGroup) {
            R4EUIReviewGroup removedElement = this.fReviewGroups.get(this.fReviewGroups.indexOf(aChildToRemove));
            removedElement.removeAllChildren(aFileRemove);
            removedElement.setEnabled(false);
            if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                this.fReviewGroups.remove(removedElement);
            }
        } else if (aChildToRemove instanceof R4EUIRuleSet) {
            R4EUIRuleSet removedElement = this.fRuleSets.get(this.fRuleSets.indexOf(aChildToRemove));
            R4EUIReviewGroup[] r4EUIReviewGroupArray = this.getGroups();
            int n = r4EUIReviewGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                R4EUIReviewGroup group = r4EUIReviewGroupArray[n2];
                if (group.getRuleSets().contains(removedElement)) {
                    final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Rule Set cannot be removed because it is being used", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", "Rule Set used in Group " + group.getName()), 4);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            dialog.open();
                        }
                    });
                    return;
                }
                ++n2;
            }
            removedElement.removeAllChildren(aFileRemove);
            removedElement.setEnabled(false);
            if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                this.fRuleSets.remove(removedElement);
            }
        }
    }

    public void removeChildrenFromUI(IR4EUIModelElement aChildToRemove) {
        if (aChildToRemove instanceof R4EUIReviewGroup) {
            R4EUIReviewGroup removedElement = this.fReviewGroups.get(this.fReviewGroups.indexOf(aChildToRemove));
            if (removedElement.isOpen()) {
                IR4EUIModelElement[] reviews;
                IR4EUIModelElement[] iR4EUIModelElementArray = reviews = removedElement.getChildren();
                int n = reviews.length;
                int n2 = 0;
                while (n2 < n) {
                    IR4EUIModelElement review = iR4EUIModelElementArray[n2];
                    if (review instanceof R4EUIReviewBasic && review.isOpen()) {
                        R4EUIModelController.FModelExt.closeR4EReview(((R4EUIReviewBasic)review).getReview());
                        R4EUIModelController.clearAnomalyMap();
                        R4EUIModelController.setActiveReview(null);
                    }
                    ++n2;
                }
                R4EUIModelController.FModelExt.closeR4EReviewGroup(removedElement.getReviewGroup());
            }
            this.fReviewGroups.remove(removedElement);
        } else {
            R4EUIRuleSet removedElement = this.fRuleSets.get(this.fRuleSets.indexOf(aChildToRemove));
            if (removedElement.isOpen()) {
                R4EUIModelController.FModelExt.closeR4EDesignRuleCollection(removedElement.getRuleSet());
            }
            this.fRuleSets.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        for (R4EUIReviewGroup group : this.fReviewGroups) {
            this.removeChildren(group, aFileRemove);
        }
        for (R4EUIRuleSet ruleSet : this.fRuleSets) {
            this.removeChildren(ruleSet, aFileRemove);
        }
    }

    @Override
    public boolean isNewChildElementCmd() {
        return this.isEnabled();
    }

    @Override
    public String getNewChildElementCmdName() {
        return "New Child Element";
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return "Add a New Child Element";
    }
}

