/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.SmtpPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ISendNotificationInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.MailServicesProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;

public class SendNotificationHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Sending Notification...";
    private static final String SMTP_ERROR_MSG = "No mail server defined in R4E SMTP preferences";

    public Object execute(final ExecutionEvent aEvent) {
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(SendNotificationHandler.COMMAND_MESSAGE, 1);
                ISelection source = HandlerUtil.getCurrentSelection((ExecutionEvent)aEvent);
                ISendNotificationInputDialog dialog = R4EUIDialogFactory.getInstance().getSendNotificationInputDialog(source);
                dialog.create();
                int result = dialog.open();
                if (result == 0) {
                    int messageType = dialog.getMessageTypeValue();
                    try {
                        switch (messageType) {
                            case 0: {
                                MailServicesProxy.sendItemsReadyNotification();
                                break;
                            }
                            case 2: {
                                MailServicesProxy.sendProgressNotification();
                                break;
                            }
                            case 3: {
                                MailServicesProxy.sendCompletionNotification();
                                break;
                            }
                            case 4: {
                                MailServicesProxy.sendQuestion(source);
                                break;
                            }
                            case 5: {
                                MailServicesProxy.sendMeetingRequest();
                                UIUtils.setNavigatorViewFocus(R4EUIModelController.getActiveReview(), 0);
                            }
                        }
                    }
                    catch (CoreException e) {
                        String smtpServersStr;
                        if (e.getMessage().contains("ComponentObjectModelException") && R4EUIPlugin.isMailAvailable() && ((smtpServersStr = SmtpPlugin.getDefault().getPreferenceStore().getString("serverList")) == null || "".equals(smtpServersStr))) {
                            e = new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", SendNotificationHandler.SMTP_ERROR_MSG));
                        }
                        UIUtils.displayCoreErrorDialog(e);
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                    }
                    catch (OutOfSyncException e) {
                        UIUtils.displaySyncErrorDialog(e);
                    }
                    monitor.worked(1);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                monitor.done();
                return Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

