/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ldap.internal.queryUtility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.eclipse.mylyn.reviews.ldap.LdapPlugin;
import org.eclipse.mylyn.reviews.ldap.internal.preferences.R4ELdapPreferencePage;
import org.eclipse.mylyn.reviews.ldap.internal.util.R4EString;
import org.eclipse.mylyn.reviews.userSearch.query.IQueryUser;
import org.eclipse.mylyn.reviews.userSearch.userInfo.IUserInfo;
import org.eclipse.mylyn.reviews.userSearch.userInfo.UserInformationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryGlobalLdapDirectory
implements IQueryUser {
    private R4ELdapPreferencePage fLdap = new R4ELdapPreferencePage();

    @Override
    public ArrayList<IUserInfo> search(String a_inUserID, String a_inName, String a_inCompany, String a_inOffice, String a_inDepartement, String a_inCountry, String a_inCity) throws NamingException, IOException {
        ArrayList<IUserInfo> userList = new ArrayList<IUserInfo>(50);
        Hashtable env = new Hashtable();
        env = (Hashtable)this.getConnectionProperties();
        InitialDirContext ctx = new InitialDirContext(env);
        StringBuilder filter = new StringBuilder(150);
        filter.append('(');
        if (a_inUserID != null && !a_inUserID.equals("")) {
            filter.append("&(" + this.fLdap.getFieldUserId() + "=" + a_inUserID + "*)");
        }
        if (a_inName != null && !a_inName.equals("")) {
            filter.append("&(" + this.fLdap.getFieldUserName() + "=" + a_inName + "*)");
        }
        if (a_inCompany != null && !a_inCompany.equals("")) {
            filter.append("&(" + this.fLdap.getFieldCompany() + "=*" + a_inCompany + "*)");
        }
        if (a_inOffice != null && !a_inOffice.equals("")) {
            filter.append("&(" + this.fLdap.getFieldOfficeName() + "=*" + a_inOffice + "*)");
        }
        if (a_inDepartement != null && !a_inDepartement.equals("")) {
            filter.append("&(" + this.fLdap.getFieldDepartment() + "=" + a_inDepartement + "*)");
        }
        if (a_inCountry != null && !a_inCountry.equals("")) {
            filter.append("&(" + this.fLdap.getFieldCountry() + "=*" + a_inCountry + "*)");
        }
        if (a_inCity != null && !a_inCity.equals("")) {
            filter.append("&(" + this.fLdap.getFieldCity() + "=" + a_inCity + "*)");
        }
        filter.append(')');
        LdapPlugin.FTracer.traceInfo("Filter search:" + filter);
        String[] returningAttributes = new String[]{this.fLdap.getFieldUserId(), this.fLdap.getFieldUserName(), this.fLdap.getFieldCompany(), this.fLdap.getFieldCity(), this.fLdap.getFieldDepartment(), this.fLdap.getFieldCountry(), this.fLdap.getFieldOfficeName(), this.fLdap.getFieldTelephone(), this.fLdap.getFieldECN(), this.fLdap.getFieldMobile(), this.fLdap.getFieldRoom(), this.fLdap.getFieldOfficeName(), this.fLdap.getFieldStreetAddress(), this.fLdap.getFieldTitle(), this.fLdap.getFieldEmail(), this.fLdap.getFieldDomain(), this.fLdap.getFieldTitle()};
        SearchControls mySearchControl = new SearchControls(2, 0L, 30000, returningAttributes, false, false);
        String dn = this.fLdap.getBaseId();
        NamingEnumeration<SearchResult> result = ctx.search(dn, filter.toString(), mySearchControl);
        while (result.hasMore()) {
            Attributes userAttribs = result.next().getAttributes();
            if (userAttribs.get(this.fLdap.getFieldEmail()) == null) continue;
            IUserInfo userData = UserInformationFactory.getInstance();
            userList.add(userData.setData(userAttribs.get(this.fLdap.getFieldUserId()), userAttribs.get(this.fLdap.getFieldUserName()), userAttribs.get(this.fLdap.getFieldCompany()), userAttribs.get(this.fLdap.getFieldOfficeName()), userAttribs.get(this.fLdap.getFieldDepartment()), userAttribs.get(this.fLdap.getFieldCountry()), userAttribs.get(this.fLdap.getFieldCity()), userAttribs.get(this.fLdap.getFieldECN()), userAttribs.get(this.fLdap.getFieldTelephone()), userAttribs.get(this.fLdap.getFieldMobile()), userAttribs.get(this.fLdap.getFieldRoom()), userAttribs.get(this.fLdap.getFieldEmail()), userAttribs.get(this.fLdap.getFieldDomain()), userAttribs.get(this.fLdap.getFieldTitle())));
        }
        ctx.close();
        env.clear();
        return userList;
    }

    @Override
    public ArrayList<IUserInfo> searchByUserId(String aUserId) throws NamingException, IOException {
        ArrayList<IUserInfo> list = null;
        if (aUserId == null || aUserId.equals("")) {
            throw new IOException(String.valueOf(R4EString.getString("messageError1")) + R4EString.getString("noUserIdProvided"));
        }
        list = this.search(aUserId, "", "", "", "", "", "");
        return list;
    }

    @Override
    public ArrayList<IUserInfo> searchByUserName(String aUserName) throws NamingException, IOException {
        ArrayList<IUserInfo> list = null;
        if (aUserName == null || aUserName.equals("")) {
            throw new IOException(String.valueOf(R4EString.getString("messageError1")) + R4EString.getString("noUserNameProvided"));
        }
        list = this.search("", aUserName, "", "", "", "", "");
        return list;
    }

    private String getProviderURL() throws IOException {
        StringBuffer sb = new StringBuffer(150);
        String serverInfo = this.fLdap.getServerInfo();
        if (serverInfo != null) {
            sb.append(serverInfo);
        } else {
            LdapPlugin.FTracer.traceWarning("Warning " + R4EString.getString("messageError4"));
        }
        return sb.toString();
    }

    private Map<String, String> getConnectionProperties() throws IOException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.getProviderURL());
        env.put("java.naming.security.authentication", this.fLdap.getAuthentication());
        LdapPlugin.FTracer.traceInfo("Info: User: " + this.fLdap.getUserName() + "\t Authentication: " + this.fLdap.getAuthentication());
        env.put("java.naming.security.principal", this.fLdap.getUserName());
        env.put("java.naming.security.credentials", this.fLdap.getPassword());
        return env;
    }

    public void main(String[] argv) {
        ArrayList<IUserInfo> userList = null;
        try {
            QueryGlobalLdapDirectory ericGlobalDir = new QueryGlobalLdapDirectory();
            try {
                userList = ericGlobalDir.search("", "", "", "", "", "", "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < userList.size()) {
                System.out.println(userList.get(i) + ", " + userList.get(i).getNTDomain());
                ++i;
            }
        }
        catch (NamingException namingException) {
            System.out.println("Error when searching in the LDAP Global Directory");
        }
    }
}

