/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum R4EUserRole implements Enumerator
{
    R4E_ROLE_REVIEWER(0, "R4E_ROLE_REVIEWER", "R4E_ROLE_REVIEWER"),
    R4E_ROLE_LEAD(1, "R4E_ROLE_LEAD", "R4E_ROLE_LEAD"),
    R4E_ROLE_AUTHOR(2, "R4E_ROLE_AUTHOR", "R4E_ROLE_AUTHOR"),
    R4E_ROLE_ORGANIZER(3, "R4E_ROLE_ORGANIZER", "R4E_ROLE_ORGANIZER");

    public static final int R4E_ROLE_REVIEWER_VALUE = 0;
    public static final int R4E_ROLE_LEAD_VALUE = 1;
    public static final int R4E_ROLE_AUTHOR_VALUE = 2;
    public static final int R4E_ROLE_ORGANIZER_VALUE = 3;
    private static final R4EUserRole[] VALUES_ARRAY;
    public static final List<R4EUserRole> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new R4EUserRole[]{R4E_ROLE_REVIEWER, R4E_ROLE_LEAD, R4E_ROLE_AUTHOR, R4E_ROLE_ORGANIZER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static R4EUserRole get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            R4EUserRole result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static R4EUserRole getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            R4EUserRole result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static R4EUserRole get(int value) {
        switch (value) {
            case 0: {
                return R4E_ROLE_REVIEWER;
            }
            case 1: {
                return R4E_ROLE_LEAD;
            }
            case 2: {
                return R4E_ROLE_AUTHOR;
            }
            case 3: {
                return R4E_ROLE_ORGANIZER;
            }
        }
        return null;
    }

    private R4EUserRole(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

