/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.Date;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.EditorProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.progress.UIJob;

public class CompareItemsHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Comparing Review Items...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(CompareItemsHandler.COMMAND_MESSAGE, 1);
                if (!selectedElements.isEmpty() && selectedElements.size() == 2 && selectedElements.get(0) instanceof R4EUIReviewItem && selectedElements.get(1) instanceof R4EUIReviewItem) {
                    R4EUIReviewItem item1 = (R4EUIReviewItem)selectedElements.get(0);
                    R4EUIReviewItem item2 = (R4EUIReviewItem)selectedElements.get(1);
                    Date item1SubmitDate = item1.getItem().getSubmitted();
                    Date item2SubmitDate = item2.getItem().getSubmitted();
                    if (item1SubmitDate == null) {
                        item1SubmitDate = new Date();
                    }
                    if (item2SubmitDate == null) {
                        item2SubmitDate = new Date();
                    }
                    if (item1SubmitDate.after(item2SubmitDate)) {
                        EditorProxy.openReviewItemCompareEditor(R4EUIModelController.getNavigatorView().getSite().getPage(), item1, item2);
                    } else {
                        EditorProxy.openReviewItemCompareEditor(R4EUIModelController.getNavigatorView().getSite().getPage(), item2, item1);
                    }
                }
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

