/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.reviews.r4e.report.impl.IR4EReport;
import org.eclipse.mylyn.reviews.r4e.report.impl.R4EReportFactory;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReview;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;

public class ReportElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Generating Report for Elements...";
    private static final String GENERATE_REPORT_DIALOG_TITLE = "Generating Report Warning";
    private static final String GENERATE_REPORT_DIALOG_MESSAGE = "Some Uncompatible Reviews cannot be included in Report" + R4EUIConstants.LINE_FEED + "Do you want to continue?" + R4EUIConstants.LINE_FEED + R4EUIConstants.LINE_FEED;
    private static final String[] GENERATE_REPORT_DIALOG_BUTTONS = new String[]{"Continue", "Cancel"};
    private static final int GENERATE_REPORT_CONTINUE_INDEX = 0;
    private static final int MAX_REVIEW_ERRORS = 5;

    public Object execute(ExecutionEvent event) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                R4EUIModelController.setJobInProgress(true);
                monitor.beginTask(ReportElementHandler.COMMAND_MESSAGE, -1);
                if (!selectedElements.isEmpty()) {
                    String groupFile = null;
                    ArrayList<File> listSelectedReviews = new ArrayList<File>();
                    ArrayList<String> listUnknownReviews = new ArrayList<String>();
                    for (IR4EUIModelElement element : selectedElements) {
                        if (element instanceof R4EUIReviewBasic) {
                            R4EUIReviewBasic extentElement = (R4EUIReviewBasic)element;
                            if (groupFile == null) {
                                groupFile = ((R4EUIReviewGroup)extentElement.getParent()).getGroupFile();
                                R4EUIPlugin.Ftracer.traceInfo("Info: Group file: " + groupFile);
                            }
                            R4EUIPlugin.Ftracer.traceInfo("Review name element " + extentElement.getReview().getName());
                            listSelectedReviews.add(new File(extentElement.getReview().getName()));
                            continue;
                        }
                        if (!(element instanceof R4EUIReview)) continue;
                        listUnknownReviews.add(((R4EUIReview)element).getReviewName());
                    }
                    if (R4EUIPlugin.isUserReportAvailable()) {
                        final int[] result = new int[]{0};
                        if (listUnknownReviews.size() > 0) {
                            final StringBuffer buffer = new StringBuffer();
                            int numReviewErrorsAppened = 0;
                            for (String unresolvedReview : listUnknownReviews) {
                                if (numReviewErrorsAppened < 5) {
                                    buffer.append(String.valueOf(unresolvedReview) + R4EUIConstants.LINE_FEED);
                                } else if (5 == numReviewErrorsAppened) {
                                    buffer.append("...");
                                }
                                ++numReviewErrorsAppened;
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    MessageDialog dialog = new MessageDialog(null, ReportElementHandler.GENERATE_REPORT_DIALOG_TITLE, null, String.valueOf(GENERATE_REPORT_DIALOG_MESSAGE) + "Unresolved Reviews: " + R4EUIConstants.LINE_FEED + buffer.toString(), 6, GENERATE_REPORT_DIALOG_BUTTONS, 0);
                                    result[0] = dialog.open();
                                }
                            });
                        }
                        if (result[0] == 0) {
                            IR4EReport reportGen = R4EReportFactory.getInstance();
                            reportGen.setReviewListSelection(listSelectedReviews.toArray(new File[listSelectedReviews.size()]));
                            reportGen.handleReportGeneration(groupFile, monitor);
                            R4EUIPlugin.Ftracer.traceInfo("Report element AVAILABLE");
                        }
                    } else {
                        R4EUIPlugin.Ftracer.traceWarning("Report element Not available");
                    }
                }
                monitor.done();
                R4EUIModelController.setJobInProgress(false);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

