/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.reviews.frame.core.model.Comment;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EComment;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.core.utils.VersionUtils;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedFile;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReview;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.PostponedAnomalyProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.upgrade.ui.R4EUpgradeController;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertySource;

public class R4EUIPostponedAnomaly
extends R4EUIAnomalyExtended {
    public static final String POSTPONED_ANOMALY_ICON_FILE = "icons/obj16/postanmly_obj.gif";
    private static final String COMPATIBILITY_ERROR_MESSAGE = "Original Anomaly cannot be updated as its meta-data version is more recent than the current application meta-data." + R4EUIConstants.LINE_FEED + "Operation cancelled";
    private static final String COMPATIBILITY_WARNING_DIALOG_TITLE = "Original Anomaly Version Mismatch Detected";
    private static final String COMPATIBILITY_WARNING_MESSAGE = "Original Anomaly format version is older than the one currently handled by this version of R4E." + R4EUIConstants.LINE_FEED + "You can update the original Anomaly, which will upgrade its parent Review version to the current one, or cancel the operation.";
    private static final String[] COMPATIBILITY_WARNING_DIALOG_BUTTONS = new String[]{"Update Anomaly", "Cancel"};

    public R4EUIPostponedAnomaly(IR4EUIModelElement aParent, R4EAnomaly aAnomaly, IR4EUIPosition aPosition) {
        super(aParent, aAnomaly, aPosition);
        this.setImage(POSTPONED_ANOMALY_ICON_FILE);
    }

    public String getToolTip() {
        return "Original Review: " + this.getOriginalReviewName() + ";" + R4EUIAnomalyBasic.buildAnomalyToolTip(this.fAnomaly);
    }

    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new PostponedAnomalyProperties(this);
        }
        return null;
    }

    public String getImageLocation() {
        return POSTPONED_ANOMALY_ICON_FILE;
    }

    public String getOriginalReviewName() {
        String originalReviewName = (String)this.fAnomaly.getInfoAtt().get((Object)"originalReviewName");
        if (originalReviewName == null) {
            originalReviewName = (String)((R4EUIPostponedFile)this.getParent()).getFileContext().getInfoAtt().get((Object)"originalReviewName");
        }
        return originalReviewName;
    }

    public void updateAnomaly(R4EAnomaly aPostponedAnomaly) throws ResourceHandlingException, OutOfSyncException {
        if (aPostponedAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED)) {
            this.fAnomaly.setEnabled(aPostponedAnomaly.isEnabled());
            if (!this.fAnomaly.isEnabled()) {
                this.close();
            }
        } else {
            this.fAnomaly.setEnabled(false);
            this.close();
        }
        this.updateState(aPostponedAnomaly.getState());
    }

    public void updateOriginalAnomaly() throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        String origReviewName = this.getOriginalReviewName();
        R4EUIReviewGroup uiGroup = null;
        if (this.getParent() instanceof R4EUIPostponedFile) {
            uiGroup = (R4EUIReviewGroup)this.getParent().getParent().getParent().getParent();
        } else if (this.getParent() instanceof R4EUIAnomalyContainer) {
            uiGroup = (R4EUIReviewGroup)this.getParent().getParent().getParent().getParent();
        } else {
            return;
        }
        R4EReview origReview = R4EUIModelController.FModelExt.openR4EReview(uiGroup.getReviewGroup(), origReviewName);
        R4EAnomaly origAnomaly = CommandUtils.getOriginalAnomaly(origReview, this.fAnomaly);
        if (origAnomaly != null) {
            CommandUtils.copyAnomalyData(origAnomaly, this.fAnomaly);
        }
        R4EUIModelController.FModelExt.closeR4EReview(origReview);
    }

    public boolean checkOrigReviewCompatibility() throws ResourceHandlingException, CompatibilityException {
        String oldVersion;
        String origReviewName = this.getOriginalReviewName();
        R4EUIReviewGroup uiGroup = (R4EUIReviewGroup)this.getParent().getParent().getParent().getParent();
        R4EUIReview originalReview = uiGroup.getReview(origReviewName);
        if (originalReview == null) {
            return false;
        }
        String newVersion = Persistence.Roots.REVIEW.getVersion();
        String validReviewName = ResourceUtils.toValidFileName((String)origReviewName);
        URI upgradeRootUri = URI.createFileURI((String)(String.valueOf(uiGroup.getReviewGroup().getFolder()) + "/" + validReviewName));
        URI reviewResourceUri = upgradeRootUri.appendSegment(String.valueOf(validReviewName) + "_review.xrer");
        try {
            oldVersion = R4EUpgradeController.getVersionFromResourceFile((URI)reviewResourceUri);
        }
        catch (IOException e1) {
            throw new ResourceHandlingException("Cannot find Review Group resource file " + reviewResourceUri, (Throwable)e1);
        }
        if (VersionUtils.compareVersions((String)newVersion, (String)oldVersion) != 0) {
            final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Version Mismatch for Original Review for Postponed Anomaly ", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "The Original Review (" + origReviewName + ") for this Postponed Anomaly is of a different version than the current Review." + R4EUIConstants.LINE_FEED + "Please update it before changing the Postponed Anomaly.", null), 4);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
            return false;
        }
        return true;
    }

    public R4EUIComment createComment(R4EComment aPostponedComment) throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
        R4EParticipant participant = uiReview.getParticipant(aPostponedComment.getUser().getId(), false);
        boolean isParticipant = true;
        if (participant == null) {
            participant = uiReview.getParticipant(aPostponedComment.getUser().getId(), true);
            isParticipant = false;
        }
        R4EUIComment uiComment = null;
        R4EComment comment = R4EUIModelController.FModelExt.createR4EComment(participant, this.fAnomaly);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)comment, R4EUIModelController.getReviewer());
        comment.setDescription(aPostponedComment.getDescription());
        comment.setCreatedOn(aPostponedComment.getCreatedOn());
        EMap info = comment.getInfoAtt();
        info.put((Object)"originalCommentId", (Object)CommandUtils.buildOriginalCommentID(aPostponedComment));
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!isParticipant) {
            bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)participant, R4EUIModelController.getReviewer());
            participant.setEnabled(false);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        uiComment = new R4EUIComment((IR4EUIModelElement)this, comment);
        this.addChildren(uiComment);
        return uiComment;
    }

    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        R4EComment origComment = null;
        String origReviewName = this.getOriginalReviewName();
        R4EUIReviewGroup uiGroup = (R4EUIReviewGroup)this.getParent().getParent().getParent().getParent();
        R4EReview origReview = R4EUIModelController.FModelExt.openR4EReview(uiGroup.getReviewGroup(), origReviewName);
        R4EAnomaly origAnomaly = CommandUtils.getOriginalAnomaly(origReview, this.fAnomaly);
        if (origAnomaly != null) {
            R4EParticipant participantInOrigReview = CommandUtils.getParticipantForReview(origReview, R4EUIModelController.getReviewer());
            origComment = R4EUIModelController.FModelExt.createR4EComment(participantInOrigReview, origAnomaly);
            Long origBookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)origComment, participantInOrigReview.getId());
            origComment.setDescription(((Comment)aModelComponent).getDescription());
            R4EUIModelController.FResourceUpdater.checkIn(origBookNum);
        }
        R4EUIModelController.FModelExt.closeR4EReview(origReview);
        if (origComment != null) {
            return this.createComment(origComment);
        }
        return null;
    }

    public boolean isOpenEditorCmd() {
        if (!(this.getParent() instanceof R4EUIPostponedFile)) {
            return false;
        }
        return this.isEnabled() && R4EUIModelController.getActiveReview() != null && ((R4EUIPostponedFile)this.getParent()).getTargetFileVersion() != null;
    }

    public void displayCompatibilityErrorDialog() {
        R4EUIPlugin.Ftracer.traceError(COMPATIBILITY_ERROR_MESSAGE);
        ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Compatibility problem Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, COMPATIBILITY_ERROR_MESSAGE, null), 4);
        dialog.open();
    }

    public int displayCompatibilityWarningDialog(String aDataVersion, String aApplVersionl) {
        R4EUIPlugin.Ftracer.traceWarning(COMPATIBILITY_WARNING_MESSAGE);
        MessageDialog dialog = new MessageDialog(null, COMPATIBILITY_WARNING_DIALOG_TITLE, null, String.valueOf(COMPATIBILITY_WARNING_MESSAGE) + R4EUIConstants.LINE_FEED + "Element meta-data Version: " + aDataVersion + R4EUIConstants.LINE_FEED + "Application meta-data Version: " + aApplVersionl, 6, COMPATIBILITY_WARNING_DIALOG_BUTTONS, 0);
        return dialog.open();
    }
}

