/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.MailServicesProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;

public class RemoveElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Removing Elements...";

    public Object execute(ExecutionEvent aEvent) {
        final ISelection selection = R4EUIModelController.getNavigatorView().getTreeViewer().getSelection();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    monitor.beginTask(RemoveElementHandler.COMMAND_MESSAGE, ((IStructuredSelection)selection).size());
                    R4EUIModelController.setJobInProgress(true);
                    boolean askConfirmation = true;
                    Object element2 = null;
                    R4EReview review = null;
                    if (R4EUIModelController.getActiveReview() != null) {
                        review = R4EUIModelController.getActiveReview().getReview();
                    }
                    ArrayList<R4EReviewComponent> removedItems = new ArrayList<R4EReviewComponent>();
                    for (Object element2 : (IStructuredSelection)selection) {
                        if (!(element2 instanceof IR4EUIModelElement)) {
                            monitor.worked(1);
                            continue;
                        }
                        monitor.subTask("Disabling element " + ((IR4EUIModelElement)element2).getName());
                        R4EUIPlugin.Ftracer.traceInfo("Disabling element " + ((IR4EUIModelElement)element2).getName());
                        final int[] result = new int[1];
                        final boolean[] fileRemove = new boolean[1];
                        final String elementName = ((IR4EUIModelElement)element2).getName();
                        if (askConfirmation) {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm(null, (String)"Disable element", (String)("Do you really want to disable element " + elementName + "?"), (String)"Don't ask again", (boolean)false, null, null);
                                    result[0] = dialog.getReturnCode();
                                    fileRemove[0] = !dialog.getToggleState();
                                }
                            });
                        }
                        if (result[0] == 0) {
                            askConfirmation = fileRemove[0];
                            try {
                                if (element2 instanceof R4EUIReviewItem) {
                                    removedItems.add((R4EReviewComponent)((R4EUIReviewItem)element2).getItem());
                                } else if (element2 instanceof R4EUIContent) {
                                    removedItems.add((R4EReviewComponent)((R4EUIContent)element2).getContent());
                                }
                                if (((IR4EUIModelElement)element2).isOpen()) {
                                    ((IR4EUIModelElement)element2).close();
                                    IR4EUIModelElement[] iR4EUIModelElementArray = ((IR4EUIModelElement)element2).getChildren();
                                    int n = iR4EUIModelElementArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IR4EUIModelElement childElement = iR4EUIModelElementArray[n2];
                                        if (childElement != null && childElement.isOpen()) {
                                            childElement.close();
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                                ((IR4EUIModelElement)element2).getParent().removeChildren(element2, false);
                            }
                            catch (ResourceHandlingException e) {
                                UIUtils.displayResourceErrorDialog(e);
                            }
                            catch (OutOfSyncException e) {
                                UIUtils.displaySyncErrorDialog(e);
                            }
                            catch (CompatibilityException e) {
                                UIUtils.displayCompatibilityErrorDialog(e);
                            }
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(element2, 0);
                        return Status.CANCEL_STATUS;
                    }
                    if (review != null && removedItems.size() > 0 && review.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL) && ((R4EFormalReview)review).getCurrent().getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION)) {
                        try {
                            MailServicesProxy.sendItemsRemovedNotification(removedItems);
                        }
                        catch (CoreException e) {
                            UIUtils.displayCoreErrorDialog(e);
                        }
                        catch (ResourceHandlingException e) {
                            UIUtils.displayResourceErrorDialog(e);
                        }
                    }
                    if (element2 != null && element2 instanceof IR4EUIModelElement) {
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(element2, 0);
                    }
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

