/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui;

import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.reviews.frame.core.utils.Tracer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class R4EUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.reviews.r4e.ui";
    public static final String JDT_PLUGIN_ID = "org.eclipse.jdt.core";
    public static final String CDT_PLUGIN_ID = "org.eclipse.cdt.core";
    public static final String R4E_REPORT_PLUGIN_ID = "org.eclipse.mylyn.reviews.r4e.report";
    public static final String R4E_REPORT_FEATURE_ID = "org.eclipse.mylyn.reviews.r4e.reports";
    public static final String R4E_MAIL_PLUGIN_ID = "org.eclipse.mylyn.reviews.r4e.mail.smtp";
    private static final String R4E_VERSION_QUALIFIER = "qualifier";
    private static R4EUIPlugin Fplugin;
    public static Tracer Ftracer;
    private FormColors fFormColors;
    private static boolean FJDTAvailable;
    private static boolean FCDTAvailable;
    private static boolean FReportAvailable;
    private static boolean FMailAvailable;

    static {
        FJDTAvailable = false;
        FCDTAvailable = false;
        FReportAvailable = false;
        FMailAvailable = false;
    }

    public R4EUIPlugin() {
        Bundle bdleMail;
        Bundle bdleCDT;
        Bundle bdleJDT = Platform.getBundle((String)JDT_PLUGIN_ID);
        if (bdleJDT != null) {
            FJDTAvailable = true;
        }
        if ((bdleCDT = Platform.getBundle((String)CDT_PLUGIN_ID)) != null) {
            FCDTAvailable = true;
        }
        if ((bdleMail = Platform.getBundle((String)R4E_MAIL_PLUGIN_ID)) != null) {
            FMailAvailable = true;
        }
    }

    public void start(BundleContext aContext) throws Exception {
        super.start(aContext);
        Fplugin = this;
        Ftracer = new Tracer();
        Ftracer.init(PLUGIN_ID);
        Ftracer.traceDebug("plugin started");
        this.verifyReportFeature();
        Ftracer.traceDebug("Report features available: " + FReportAvailable);
    }

    private void verifyReportFeature() {
        IBundleGroupProvider[] grpprovider;
        Version ver;
        Bundle bdleReport = Platform.getBundle((String)R4E_REPORT_PLUGIN_ID);
        if (bdleReport != null && (ver = bdleReport.getVersion()).getQualifier().equals(R4E_VERSION_QUALIFIER)) {
            FReportAvailable = true;
            Ftracer.traceDebug("In a runtime environment for the report");
            return;
        }
        IBundleGroupProvider[] iBundleGroupProviderArray = grpprovider = Platform.getBundleGroupProviders();
        int n = grpprovider.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider element = iBundleGroupProviderArray[n2];
            IBundleGroup[] bdlgrp = element.getBundleGroups();
            Ftracer.traceDebug("bundle group count: " + bdlgrp.length);
            int j = 0;
            while (j < bdlgrp.length) {
                if (bdlgrp[j].getIdentifier().contains(R4E_REPORT_FEATURE_ID)) {
                    Ftracer.traceDebug("\t bdlgrp[" + j + "] : " + bdlgrp[j].getName() + "\t : " + bdlgrp[j].getProviderName() + "\t version: " + bdlgrp[j].getVersion() + "\t : " + bdlgrp[j].getIdentifier());
                    FReportAvailable = true;
                    break;
                }
                ++j;
            }
            ++n2;
        }
    }

    public void stop(BundleContext aContext) throws Exception {
        if (this.fFormColors != null) {
            this.fFormColors.dispose();
            this.fFormColors = null;
        }
        Fplugin = null;
        super.stop(aContext);
        Ftracer.traceDebug("plugin stopped");
    }

    public FormColors getFormColors(Display display) {
        if (this.fFormColors == null) {
            this.fFormColors = new FormColors(display);
            this.fFormColors.markShared();
        }
        return this.fFormColors;
    }

    public static R4EUIPlugin getDefault() {
        return Fplugin;
    }

    public static boolean isJDTAvailable() {
        return FJDTAvailable;
    }

    public static boolean isCDTAvailable() {
        return FCDTAvailable;
    }

    public static boolean isUserReportAvailable() {
        return FReportAvailable;
    }

    public static boolean isMailAvailable() {
        return FMailAvailable;
    }

    public void logError(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }

    public void logWarning(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }

    public void logInfo(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }
}

