/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.frame.ui.annotation.impl;

import java.lang.reflect.Method;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IEditorInputListener;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationModel;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationSupport;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ReviewAnnotationSupport
implements IReviewAnnotationSupport {
    protected IReviewAnnotationModel fAnnotationModel = null;
    protected IEditorInputListener fViewerListener = null;

    public ReviewAnnotationSupport(Object aFileVersion) {
        if (aFileVersion != null) {
            this.fAnnotationModel = this.createAnnotationModel(aFileVersion);
            this.fAnnotationModel.setFile(aFileVersion);
        }
    }

    protected abstract IReviewAnnotationModel createAnnotationModel(Object var1);

    protected abstract void install(Object var1);

    public ITextEditor getEditor() {
        if (this.fViewerListener != null) {
            return this.fViewerListener.getEditor();
        }
        return null;
    }

    public IReviewAnnotationModel getAnnotationModel() {
        return this.fAnnotationModel;
    }

    public void setAnnotationModelElement(Object aElement) {
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.setFile(aElement);
        }
    }

    public void refreshAnnotations(Object aElement) {
        if (this.fAnnotationModel != null) {
            if (aElement != null) {
                this.fAnnotationModel.setFile(aElement);
            }
            this.fAnnotationModel.refreshAnnotations();
        }
    }

    public void addAnnotation(Object aElement, Object aFile) {
        if (this.fAnnotationModel != null && aFile.equals(this.fAnnotationModel.getFile())) {
            this.fAnnotationModel.addAnnotation(aElement);
        }
    }

    public void updateAnnotation(Object aElement, Object aFile) {
        if (this.fAnnotationModel != null && aFile.equals(this.fAnnotationModel.getFile())) {
            this.fAnnotationModel.updateAnnotation(aElement);
        }
    }

    public void removeAnnotation(Object aElement, Object aFile) {
        if (this.fAnnotationModel != null && aFile.equals(this.fAnnotationModel.getFile())) {
            this.fAnnotationModel.removeAnnotation(aElement);
        }
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null) {
            return false;
        }
        if (!this.getClass().equals(aObject.getClass())) {
            return false;
        }
        ReviewAnnotationSupport other = (ReviewAnnotationSupport)aObject;
        return !(this.fAnnotationModel == null ? other.fAnnotationModel != null : !this.fAnnotationModel.equals(other.fAnnotationModel));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fAnnotationModel == null ? 0 : this.fAnnotationModel.hashCode());
        return result;
    }

    public static SourceViewer getSourceViewer(MergeSourceViewer aMergeViewer) {
        if (SourceViewer.class.isInstance(aMergeViewer)) {
            return (SourceViewer)SourceViewer.class.cast(aMergeViewer);
        }
        try {
            Method getSourceViewerRefl = MergeSourceViewer.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerRefl.setAccessible(true);
            Object returnValue = getSourceViewerRefl.invoke((Object)aMergeViewer, new Object[0]);
            if (returnValue instanceof SourceViewer) {
                return (SourceViewer)returnValue;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

