/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ECommentType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EID;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleRank;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotationText;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4ECommentAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class R4EAnomalyAnnotation
extends R4EAnnotation {
    private final List<String> fDescriptionLines = new ArrayList<String>();

    public R4EAnomalyAnnotation(R4EUIAnomalyBasic aSourceAnomaly) {
        super(aSourceAnomaly, R4EAnomalyAnnotation.getAnnotationType(aSourceAnomaly), aSourceAnomaly.getName());
        StringTokenizer st = new StringTokenizer(aSourceAnomaly.getAnomaly().getDescription(), R4EUIConstants.LINE_FEED);
        while (st.hasMoreElements()) {
            this.fDescriptionLines.add((String)st.nextElement());
        }
    }

    public IR4EUIPosition getR4EPosition() {
        return ((R4EUIAnomalyBasic)this.fSourceElement).getPosition();
    }

    public R4EID getId() {
        return ((R4EUIAnomalyBasic)this.fSourceElement).getAnomaly().getId();
    }

    private static String getAnnotationType(R4EUIAnomalyBasic aSourceAnomaly) {
        if (aSourceAnomaly.isEnabled()) {
            if (aSourceAnomaly.isTerminalState()) {
                return "org.eclipse.mylyn.reviews.r4e.ui.anomalyClosed.Annotation";
            }
            return "org.eclipse.mylyn.reviews.r4e.ui.anomalyOpen.Annotation";
        }
        return "org.eclipse.mylyn.reviews.r4e.ui.anomalyDisabled.Annotation";
    }

    public Object getParent() {
        return this.getParentInput();
    }

    public Object[] getChildren() {
        EList assignees;
        String ruleId;
        R4EDesignRuleRank rank;
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(new R4EAnnotationText((Object)this, "Description: ", this.fDescriptionLines));
        ArrayList<String> detailsValues = new ArrayList<String>();
        detailsValues.add("Added By: " + ((R4EUIAnomalyBasic)this.fSourceElement).getAnomaly().getUser().getId());
        R4ECommentType commentType = (R4ECommentType)((R4EUIAnomalyBasic)this.fSourceElement).getAnomaly().getType();
        if (commentType != null) {
            detailsValues.add("Class: " + UIUtils.getClassStr(commentType.getType()));
        }
        if ((rank = ((R4EUIAnomalyBasic)this.fSourceElement).getAnomaly().getRank()) != null && !rank.equals((Object)R4EDesignRuleRank.R4E_RANK_NONE)) {
            detailsValues.add("Rank: " + UIUtils.getRankStr(rank));
        }
        if ((ruleId = ((R4EUIAnomalyBasic)this.fSourceElement).getAnomaly().getRuleID()) != null && !ruleId.equals("")) {
            detailsValues.add("Rule ID: " + ruleId);
        }
        if ((assignees = ((R4EUIAnomalyBasic)this.fSourceElement).getAnomaly().getAssignedTo()) != null && assignees.size() > 0 && !((String)assignees.get(0)).equals("")) {
            detailsValues.add("Assigned to: " + (String)assignees.get(0));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
        Date dueDate = ((R4EUIAnomalyBasic)this.fSourceElement).getAnomaly().getDueDate();
        if (dueDate != null) {
            detailsValues.add("Due Date: " + dateFormat.format(dueDate));
        }
        values.add(new R4EAnnotationText((Object)this, "Details: ", detailsValues));
        IR4EUIModelElement[] comments = ((R4EUIAnomalyBasic)this.fSourceElement).getChildren();
        if (comments != null && comments.length > 0) {
            IR4EUIModelElement[] iR4EUIModelElementArray = comments;
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                IR4EUIModelElement comment = iR4EUIModelElementArray[n2];
                values.add((Object)new R4ECommentAnnotation((R4EUIComment)comment, this));
                ++n2;
            }
        }
        return values.toArray(new Object[values.size()]);
    }

    public boolean hasChildren() {
        return true;
    }
}

