/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.ReadLines;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ReadLinesService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof ReadLines)) {
            return Status.CANCEL_STATUS;
        }
        BufferedReader br = null;
        try {
            try {
                URI uri = new URI(((ReadLines)command).getUri());
                EclFile file = FileResolver.resolve((URI)uri);
                if (file != null) {
                    uri = file.toURI();
                }
                br = new BufferedReader(new InputStreamReader(file.read()));
                String line = "";
                while ((line = br.readLine()) != null) {
                    context.getOutput().write((Object)line);
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.rcptt.ecl.data", e.getMessage(), (Throwable)e);
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                return status;
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return Status.OK_STATUS;
    }
}

