/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.ExportDestinationTab;
import org.eclipse.pde.internal.ui.wizards.exports.ExportOptionsTab;
import org.eclipse.pde.internal.ui.wizards.exports.JARSigningTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public abstract class BaseExportWizardPage
extends AbstractExportWizardPage {
    protected ExportPart fExportPart;
    private IStructuredSelection fSelection;
    protected ExportDestinationTab fDestinationTab;
    protected ExportOptionsTab fOptionsTab;
    protected JARSigningTab fJARSiginingTab;
    protected TabFolder fTabFolder;

    public BaseExportWizardPage(IStructuredSelection selection, String name, String choiceLabel) {
        super(name);
        this.fSelection = selection;
        this.fExportPart = new ExportPart(choiceLabel, new String[]{PDEUIMessages.WizardCheckboxTablePart_selectAll, PDEUIMessages.WizardCheckboxTablePart_deselectAll, PDEUIMessages.ExportWizard_workingSet});
        this.setDescription(PDEUIMessages.ExportWizard_Plugin_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.createViewer(container);
        this.fTabFolder = new TabFolder(container, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(768));
        this.createTabs(this.fTabFolder, this.getDialogSettings());
        this.initializeViewer();
        if (this.getErrorMessage() != null) {
            this.setMessage(this.getErrorMessage());
            this.setErrorMessage(null);
        }
        this.setControl((Control)container);
        this.hookHelpContext((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    protected void createTabs(TabFolder folder, IDialogSettings settings) {
        this.createDestinationTab(folder);
        this.createOptionsTab(folder);
        this.fDestinationTab.initialize(settings);
        this.fOptionsTab.initialize(settings);
        if (this.fOptionsTab.useJARFormat()) {
            this.createJARSigningTab(folder);
            this.fJARSiginingTab.initialize(settings);
        }
    }

    protected void createDestinationTab(TabFolder folder) {
        this.fDestinationTab = new ExportDestinationTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fDestinationTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.ExportWizard_destination);
    }

    protected void createOptionsTab(TabFolder folder) {
        this.fOptionsTab = new ExportOptionsTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fOptionsTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.ExportWizard_options);
    }

    protected void createJARSigningTab(TabFolder folder) {
        this.fJARSiginingTab = new JARSigningTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fJARSiginingTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.AdvancedPluginExportPage_signJar);
    }

    protected void createViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fExportPart.createControl(composite);
        GridData gd = (GridData)this.fExportPart.getControl().getLayoutData();
        gd.heightHint = 125;
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
        CheckboxTableViewer viewer = this.fExportPart.getTableViewer();
        viewer.setContentProvider((IContentProvider)new ExportListProvider());
        viewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        viewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSource() instanceof CheckboxTableViewer) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ((CheckboxTableViewer)event.getSource()).setChecked(selection.getFirstElement(), !((CheckboxTableViewer)event.getSource()).getChecked(selection.getFirstElement()));
                    BaseExportWizardPage.this.fExportPart.updateCounter(((CheckboxTableViewer)event.getSource()).getCheckedElements().length);
                }
            }
        });
        this.fExportPart.getTableViewer().setInput(this.getInput());
    }

    protected abstract Object getInput();

    protected void initializeViewer() {
        Object[] elems = this.fSelection.toArray();
        ArrayList<IModel> checked = new ArrayList<IModel>(elems.length);
        int i = 0;
        while (i < elems.length) {
            IModel model;
            Object elem = elems[i];
            IProject project = null;
            if (elem instanceof IFile) {
                IFile file = (IFile)elem;
                project = file.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
            } else if (elem instanceof IJavaProject) {
                project = ((IJavaProject)elem).getProject();
            }
            if (project != null && (model = this.findModelFor((IAdaptable)project)) != null && !checked.contains(model)) {
                checked.add(model);
            }
            ++i;
        }
        this.fExportPart.setSelection(checked.toArray());
        if (checked.size() > 0) {
            this.fExportPart.getTableViewer().reveal(checked.get(0));
        }
    }

    private void handleWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.getShell(), true);
        if (dialog.open() == 0) {
            ArrayList<IModel> models = new ArrayList<IModel>();
            IWorkingSet[] workingSets = dialog.getSelection();
            int i = 0;
            while (i < workingSets.length) {
                IAdaptable[] elements = workingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IModel model = this.findModelFor(elements[j]);
                    if (this.isValidModel(model)) {
                        models.add(model);
                    }
                    ++j;
                }
                ++i;
            }
            this.fExportPart.setSelection(models.toArray());
        }
    }

    public Object[] getSelectedItems() {
        return this.fExportPart.getSelection();
    }

    @Override
    protected void pageChanged() {
        String error;
        if (this.getMessage() != null) {
            this.setMessage(null);
        }
        if (this.fOptionsTab != null) {
            String path = this.fOptionsTab.getAntBuildFileName();
            String warningMessage = null;
            if (path != null && path.length() > 0 && "build.xml".equals(new Path(path).lastSegment())) {
                warningMessage = PDEUIMessages.ExportOptionsTab_antReservedMessage;
            }
            this.setMessage(warningMessage, 2);
        }
        String string = error = this.fExportPart.getSelectionCount() > 0 ? null : PDEUIMessages.ExportWizard_status_noselection;
        if (error == null) {
            error = this.validateTabs();
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    protected String validateTabs() {
        String message = this.fDestinationTab.validate();
        if (message == null) {
            message = this.fOptionsTab.validate();
        }
        if (message == null && this.fTabFolder.getItemCount() > 2) {
            message = this.fJARSiginingTab.validate();
        }
        return message;
    }

    protected abstract void hookHelpContext(Control var1);

    protected abstract boolean isValidModel(IModel var1);

    public abstract Object[] getListElements();

    protected abstract IModel findModelFor(IAdaptable var1);

    @Override
    protected void saveSettings(IDialogSettings settings) {
        this.fDestinationTab.saveSettings(settings);
        this.fOptionsTab.saveSettings(settings);
        if (this.fJARSiginingTab != null) {
            this.fJARSiginingTab.saveSettings(settings);
        }
    }

    protected boolean doExportToDirectory() {
        return this.fDestinationTab.doExportToDirectory();
    }

    protected String getFileName() {
        return this.fDestinationTab.getFileName();
    }

    protected String getDestination() {
        return this.fDestinationTab.getDestination();
    }

    protected boolean doInstall() {
        return this.fDestinationTab.doInstall();
    }

    protected boolean doExportSource() {
        return this.fOptionsTab.doExportSource();
    }

    protected boolean doExportSourceBundles() {
        return this.fOptionsTab.doExportSourceBundles();
    }

    protected boolean useJARFormat() {
        return this.fOptionsTab.useJARFormat();
    }

    protected boolean allowBinaryCycles() {
        return this.fOptionsTab.doBinaryCycles();
    }

    protected boolean useWorkspaceCompiledClasses() {
        return this.fOptionsTab.useWorkspaceCompiledClasses();
    }

    protected boolean doGenerateAntFile() {
        return this.fOptionsTab.doGenerateAntFile();
    }

    protected String getAntBuildFileName() {
        return this.fOptionsTab.getAntBuildFileName();
    }

    protected String getQualifier() {
        return this.fOptionsTab.getQualifier();
    }

    protected String[] getSigningInfo() {
        if (this.fJARSiginingTab == null || this.fTabFolder.getItemCount() < 3) {
            return null;
        }
        return this.fJARSiginingTab.getSigningInfo();
    }

    protected abstract void adjustAdvancedTabsVisibility();

    protected void adjustJARSigningTabVisibility() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.useJARFormat()) {
            if (this.fTabFolder.getItemCount() < 3) {
                this.createJARSigningTab(this.fTabFolder);
                this.fJARSiginingTab.initialize(settings);
            }
        } else if (this.fTabFolder.getItemCount() >= 3) {
            this.fJARSiginingTab.saveSettings(settings);
            this.fTabFolder.getItem(2).dispose();
        }
    }

    class ExportListProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ExportListProvider() {
        }

        public Object[] getElements(Object parent) {
            return BaseExportWizardPage.this.getListElements();
        }
    }

    class ExportPart
    extends WizardCheckboxTablePart {
        public ExportPart(String label, String[] buttonLabels) {
            super(label, buttonLabels);
        }

        @Override
        public void updateCounter(int count) {
            super.updateCounter(count);
            BaseExportWizardPage.this.pageChanged();
        }

        @Override
        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    this.handleSelectAll(true);
                    break;
                }
                case 1: {
                    this.handleSelectAll(false);
                    break;
                }
                case 2: {
                    BaseExportWizardPage.this.handleWorkingSets();
                }
            }
        }
    }
}

