/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.CommitUtil;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RevertHandler
extends AbstractHistoryCommandHandler {
    public static final String ID = "org.eclipse.egit.ui.history.Revert";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<RevCommit> commits = this.getSelectedCommits(event);
        Repository repo = this.getRepository(event);
        if (repo == null) {
            return null;
        }
        try {
            boolean allOnCurrentBranch = true;
            for (RevCommit commit : commits) {
                if (CommitUtil.isCommitInCurrentBranch((RevCommit)commit, (Repository)repo)) continue;
                allOnCurrentBranch = false;
                break;
            }
            if (!allOnCurrentBranch) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (String)UIText.RevertHandler_Error_Title, (String)UIText.RevertHandler_CommitsNotOnCurrentBranch);
                return null;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.RevertHandler_ErrorCheckingIfCommitsAreOnCurrentBranch, (Throwable)e);
        }
        BasicConfigurationDialog.show(repo);
        ArrayList<RepositoryCommit> repositoryCommits = new ArrayList<RepositoryCommit>();
        for (RevCommit commit : commits) {
            repositoryCommits.add(new RepositoryCommit(repo, commit));
        }
        StructuredSelection selected = new StructuredSelection(repositoryCommits);
        CommonUtils.runCommand("org.eclipse.egit.ui.commit.Revert", (IStructuredSelection)selected);
        return null;
    }
}

