/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

abstract class LogicalPackagesProvider
implements IPropertyChangeListener,
IElementChangedListener {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected Map<String, LogicalPackage> fMapToLogicalPackage;
    protected Map<String, IPackageFragment> fMapToPackageFragments;
    protected boolean fCompoundState;
    protected StructuredViewer fViewer;
    protected boolean fInputIsProject;

    public LogicalPackagesProvider(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.fCompoundState = this.isInCompoundState();
        this.fInputIsProject = true;
        this.fMapToLogicalPackage = new HashMap<String, LogicalPackage>();
        this.fMapToPackageFragments = new HashMap<String, IPackageFragment>();
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void addFragmentsToMap(IPackageFragment[] packageFragments) {
        int i = 0;
        while (i < packageFragments.length) {
            IPackageFragment fragment = packageFragments[i];
            String key = this.getKey(fragment);
            this.fMapToPackageFragments.put(key, fragment);
            ++i;
        }
    }

    protected String getKey(IPackageFragment fragment) {
        return String.valueOf(fragment.getElementName()) + fragment.getJavaProject().getElementName();
    }

    public LogicalPackage findLogicalPackage(IPackageFragment fragment) {
        Assert.isNotNull((Object)fragment);
        if (this.isInCompoundState()) {
            return this.fMapToLogicalPackage.get(this.getKey(fragment));
        }
        return null;
    }

    protected Object[] combineSamePackagesIntoLogialPackages(IPackageFragment[] packageFragments) {
        if (!this.fCompoundState) {
            return packageFragments;
        }
        ArrayList<LogicalPackage> newChildren = new ArrayList<LogicalPackage>();
        int i = 0;
        while (i < packageFragments.length) {
            IPackageFragment fragment = packageFragments[i];
            if (fragment != null) {
                LogicalPackage lp = this.findLogicalPackage(fragment);
                if (lp != null) {
                    if (lp.belongs(fragment)) {
                        lp.add(fragment);
                    }
                    if (!newChildren.contains((Object)lp)) {
                        newChildren.add(lp);
                    }
                } else {
                    String key = this.getKey(fragment);
                    IPackageFragment frag = this.fMapToPackageFragments.get(key);
                    if (frag != null && !fragment.equals(frag)) {
                        lp = new LogicalPackage(frag);
                        lp.add(fragment);
                        newChildren.remove(frag);
                        newChildren.add(lp);
                        this.fMapToLogicalPackage.put(key, lp);
                        this.fMapToPackageFragments.remove(frag);
                    } else {
                        this.fMapToPackageFragments.put(key, fragment);
                        newChildren.add((LogicalPackage)fragment);
                    }
                }
            }
            ++i;
        }
        return newChildren.toArray();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fCompoundState == this.isInCompoundState()) {
            return;
        }
        this.fCompoundState = this.isInCompoundState();
        if (!this.isInCompoundState()) {
            this.fMapToLogicalPackage.clear();
            this.fMapToPackageFragments.clear();
        }
        if (this.fViewer instanceof TreeViewer) {
            TreeViewer viewer = (TreeViewer)this.fViewer;
            Object[] expandedObjects = viewer.getExpandedElements();
            viewer.refresh();
            viewer.setExpandedElements(expandedObjects);
        } else {
            this.fViewer.refresh();
        }
    }

    protected boolean isInCompoundState() {
        return true;
    }

    public void dispose() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fMapToLogicalPackage = null;
        this.fMapToPackageFragments = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInputIsProject = newInput instanceof IJavaProject;
        if (viewer instanceof StructuredViewer) {
            this.fViewer = (StructuredViewer)viewer;
        }
    }

    protected abstract void processDelta(IJavaElementDelta var1) throws JavaModelException;

    protected boolean isClassPathChange(IJavaElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }
}

