/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class BuildPathsPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
    private static final String PAGE_SETTINGS = "BuildPathsPropertyPage";
    private static final String INDEX = "pageIndex";
    public static final Object DATA_ADD_ENTRY = "add_classpath_entry";
    public static final Object DATA_REVEAL_ENTRY = "select_classpath_entry";
    public static final Object DATA_REVEAL_ATTRIBUTE_KEY = "select_classpath_attribute_key";
    public static final Object DATA_BLOCK = "block_until_buildpath_applied";
    private BuildPathsBlock fBuildPathsBlock;
    private boolean fBlockOnApply = false;

    protected Control createContents(Composite parent) {
        this.noDefaultButton();
        IProject project = this.getProject();
        Control result = project == null || !this.isJavaProject(project) ? this.createWithoutJava(parent) : (!project.isOpen() ? this.createForClosedProject(parent) : this.createWithJava(parent, project));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.build_path_property_page_context");
    }

    private IDialogSettings getSettings() {
        IDialogSettings javaSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = javaSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = javaSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 3);
        }
        return pageSettings;
    }

    public boolean okToLeave() {
        if (this.fBuildPathsBlock != null && this.fBuildPathsBlock.hasChangesInDialog()) {
            String title = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_title;
            String message = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_message;
            String[] buttonLabels = new String[]{PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_save, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_discard, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_ignore};
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
            int res = dialog.open();
            if (res == 0) {
                this.fBlockOnApply = true;
                return this.performOk() && super.okToLeave();
            }
            if (res == 1) {
                this.fBuildPathsBlock.init(JavaCore.create((IProject)this.getProject()), null, null);
            }
        }
        return super.okToLeave();
    }

    public void setVisible(boolean visible) {
        if (this.fBuildPathsBlock != null && visible && !this.fBuildPathsBlock.hasChangesInDialog() && this.fBuildPathsBlock.hasChangesInClasspathFile()) {
            this.fBuildPathsBlock.init(JavaCore.create((IProject)this.getProject()), null, null);
        }
        super.setVisible(visible);
    }

    private Control createWithJava(Composite parent, IProject project) {
        IWorkbenchPreferenceContainer pageContainer = null;
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            pageContainer = (IWorkbenchPreferenceContainer)container;
        }
        this.fBuildPathsBlock = new BuildPathsBlock(new BusyIndicatorRunnableContext(), this, this.getSettings().getInt(INDEX), false, pageContainer);
        this.fBuildPathsBlock.init(JavaCore.create((IProject)project), null, null);
        return this.fBuildPathsBlock.createControl(parent);
    }

    private Control createWithoutJava(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_no_java_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_closed_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        return adaptable == null ? null : (IProject)adaptable.getAdapter(IProject.class);
    }

    private boolean isJavaProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fBuildPathsBlock != null) {
            this.getSettings().put(INDEX, this.fBuildPathsBlock.getPageIndex());
            if (this.fBuildPathsBlock.hasChangesInDialog() || this.fBuildPathsBlock.isClassfileMissing()) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                        BuildPathsPropertyPage.this.fBuildPathsBlock.configureJavaProject(monitor);
                    }
                };
                WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
                if (this.fBlockOnApply) {
                    try {
                        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle(e, this.getShell(), PreferencesMessages.BuildPathsPropertyPage_error_title, PreferencesMessages.BuildPathsPropertyPage_error_message);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                } else {
                    op.runAsUserJob(PreferencesMessages.BuildPathsPropertyPage_job_title, null);
                }
            }
        }
        return true;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            Object entryToAdd;
            Map map = (Map)data;
            Object selectedLibrary = map.get(DATA_REVEAL_ENTRY);
            if (selectedLibrary instanceof IClasspathEntry) {
                String attributeKey;
                IClasspathEntry entry = (IClasspathEntry)selectedLibrary;
                Object attr = map.get(DATA_REVEAL_ATTRIBUTE_KEY);
                String string = attributeKey = attr instanceof String ? (String)attr : null;
                if (this.fBuildPathsBlock != null) {
                    this.fBuildPathsBlock.setElementToReveal(entry, attributeKey);
                }
            }
            if ((entryToAdd = map.get(DATA_ADD_ENTRY)) instanceof IClasspathEntry && this.fBuildPathsBlock != null) {
                this.fBuildPathsBlock.addElement((IClasspathEntry)entryToAdd);
            }
            this.fBlockOnApply = Boolean.TRUE.equals(map.get(DATA_BLOCK));
        }
    }
}

