/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import org.eclipse.core.commands.Command;
import org.eclipse.pde.internal.ui.commands.CommandComposerPart;
import org.eclipse.pde.internal.ui.commands.QueryControl;
import org.eclipse.pde.internal.ui.commands.TagManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class QueryByTag
extends QueryControl {
    private TagManager fTagManager;
    private Combo fTagsCombo;
    private TagManager.Listener fTagManagerListener;

    public QueryByTag(CommandComposerPart csp, Composite comp) {
        super(csp, comp);
    }

    @Override
    protected void createGroupContents(Group parent) {
        this.fTagManager = this.fCSP.getTagManager();
        this.fTagsCombo = new Combo((Composite)parent, 12);
        this.fTagsCombo.setLayoutData((Object)new GridData(768));
        this.fToolkit.adapt((Control)this.fTagsCombo, true, true);
        this.fTagManagerListener = new TagManagerListener();
        this.fCSP.getTagManager().addListener(this.fTagManagerListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (QueryByTag.this.fTagManagerListener != null) {
                    QueryByTag.this.fTagManager.removeListener(QueryByTag.this.fTagManagerListener);
                }
            }
        });
    }

    @Override
    protected String getName() {
        return "Query Commands by Tags";
    }

    private void refreshTags() {
        this.fTagsCombo.removeAll();
        String[] tags = this.fTagManager.getTags();
        int i = 0;
        while (i < tags.length) {
            this.fTagsCombo.add(tags[i]);
            ++i;
        }
    }

    @Override
    protected Command[] getCommands() {
        String tagText = this.fTagsCombo.getText();
        return this.fCSP.getTagManager().getCommands(tagText);
    }

    @Override
    protected void enable(boolean enable) {
        this.fGroup.setEnabled(enable);
        this.fTagsCombo.setEnabled(enable);
    }

    private class TagManagerListener
    implements TagManager.Listener {
        private TagManagerListener() {
        }

        @Override
        public void tagManagerChanged() {
            QueryByTag.this.refreshTags();
        }
    }
}

