/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commands.shared;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.RebaseTargetSelectionDialog;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveHandler;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class RebaseCurrentRefCommand
extends AbstractRebaseCommandHandler {
    private Ref ref;
    private boolean interactive;
    private boolean preserveMerges;

    public RebaseCurrentRefCommand() {
        super(UIText.RebaseCurrentRefCommand_RebasingCurrentJobName, UIText.RebaseCurrentRefCommand_RebaseCanceledMessage);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.setRef(event);
        if (this.ref == null) {
            return null;
        }
        return super.execute(event);
    }

    private void setRef(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            Object selected = selection.getFirstElement();
            this.ref = this.getRef(selected);
        } else {
            this.ref = null;
        }
        Object context = event.getApplicationContext();
        if (!(context instanceof IEvaluationContext)) {
            return;
        }
        Repository repository = SelectionUtils.getRepository((IEvaluationContext)context);
        if (repository == null) {
            return;
        }
        BasicConfigurationDialog.show(repository);
        String currentFullBranch = this.getFullBranch(repository);
        if (this.ref != null && this.ref.getName().equals(currentFullBranch)) {
            this.ref = null;
        }
        if (this.ref == null) {
            RebaseTargetSelectionDialog rebaseTargetSelectionDialog = new RebaseTargetSelectionDialog(this.getShell(event), repository);
            if (rebaseTargetSelectionDialog.open() == 0) {
                String refName = rebaseTargetSelectionDialog.getRefName();
                try {
                    this.ref = repository.getRef(refName);
                }
                catch (IOException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
                this.interactive = rebaseTargetSelectionDialog.isInteractive();
                this.preserveMerges = rebaseTargetSelectionDialog.isPreserveMerges();
            } else {
                return;
            }
        }
        this.jobname = NLS.bind((String)UIText.RebaseCurrentRefCommand_RebasingCurrentJobName, (Object)Repository.shortenRefName((String)currentFullBranch), (Object)this.ref.getName());
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext ctx = (IEvaluationContext)evaluationContext;
            Repository repo = SelectionUtils.getRepository(ctx);
            if (repo != null) {
                boolean enabled = RebaseCurrentRefCommand.isEnabledForState(repo, repo.getRepositoryState());
                this.setBaseEnabled(enabled);
            } else {
                this.setBaseEnabled(false);
            }
            return;
        }
        this.setBaseEnabled(true);
    }

    public static boolean isEnabledForState(Repository repo, RepositoryState state) {
        return state == RepositoryState.SAFE && RebaseCurrentRefCommand.hasHead(repo);
    }

    private static boolean hasHead(Repository repo) {
        try {
            Ref headRef = repo.getRef("HEAD");
            return headRef != null && headRef.getObjectId() != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private String getFullBranch(Repository repository) throws ExecutionException {
        try {
            return repository.getFullBranch();
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.RebaseCurrentRefCommand_ErrorGettingCurrentBranchMessage, (Throwable)e);
        }
    }

    @Override
    protected RebaseOperation createRebaseOperation(Repository repository) throws ExecutionException {
        RebaseInteractiveHandler handler = this.interactive ? RebaseInteractiveHandler.INSTANCE : null;
        RebaseOperation operation = new RebaseOperation(repository, this.ref, (RebaseCommand.InteractiveHandler)handler);
        operation.setPreserveMerges(this.preserveMerges);
        return operation;
    }
}

