/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.service.weaving;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;

public class Supplementer {
    private final ManifestElement[] supplementBundle;
    private final Set<Bundle> supplementedBundles;
    private final Bundle supplementer;
    private final Bundle supplementerHost;
    private final ManifestElement[] supplementExporter;
    private final ManifestElement[] supplementImporter;

    public Supplementer(Bundle bundle, Bundle bundle2, ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2, ManifestElement[] manifestElementArray3) {
        this.supplementer = bundle;
        this.supplementerHost = bundle2 != null ? bundle2 : bundle;
        this.supplementBundle = manifestElementArray;
        this.supplementImporter = manifestElementArray2;
        this.supplementExporter = manifestElementArray3;
        this.supplementedBundles = new HashSet<Bundle>();
    }

    public void addSupplementedBundle(Bundle bundle) {
        this.supplementedBundles.add(bundle);
    }

    private boolean equals_wild(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (!string.endsWith("*")) {
            return false;
        }
        String string3 = string.substring(0, string.length() - 1);
        return string2.startsWith(string3);
    }

    public Bundle[] getSupplementedBundles() {
        return this.supplementedBundles.toArray(new Bundle[this.supplementedBundles.size()]);
    }

    public Bundle getSupplementerBundle() {
        return this.supplementer;
    }

    public Bundle getSupplementerHost() {
        return this.supplementerHost;
    }

    public String getSymbolicName() {
        return this.supplementer.getSymbolicName();
    }

    public boolean isSupplemented(Bundle bundle) {
        return this.supplementedBundles.contains(bundle);
    }

    public boolean matchesSupplementExporter(ManifestElement[] manifestElementArray) {
        boolean bl = false;
        if (this.supplementExporter != null) {
            int n = 0;
            while (!bl && n < this.supplementExporter.length) {
                ManifestElement manifestElement = this.supplementExporter[n];
                int n2 = 0;
                while (!bl && n2 < manifestElementArray.length) {
                    ManifestElement manifestElement2 = manifestElementArray[n2];
                    if (manifestElement.getValue().equals(manifestElement2.getValue())) {
                        bl = true;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean matchesSupplementImporter(ManifestElement[] manifestElementArray) {
        boolean bl = false;
        if (this.supplementImporter != null) {
            int n = 0;
            while (!bl && n < this.supplementImporter.length) {
                ManifestElement manifestElement = this.supplementImporter[n];
                int n2 = 0;
                while (!bl && n2 < manifestElementArray.length) {
                    ManifestElement manifestElement2 = manifestElementArray[n2];
                    if (manifestElement.getValue().equals(manifestElement2.getValue())) {
                        bl = true;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean matchSupplementer(String string) {
        boolean bl = false;
        if (this.supplementBundle != null) {
            int n = 0;
            while (!bl && n < this.supplementBundle.length) {
                ManifestElement manifestElement = this.supplementBundle[n];
                if (this.equals_wild(manifestElement.getValue(), string)) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    public void removeSupplementedBundle(Bundle bundle) {
        this.supplementedBundles.remove(bundle);
    }
}

