/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.WriteLines;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.filesystem.Util;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class WriteLinesService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof WriteLines)) {
            return Status.CANCEL_STATUS;
        }
        WriteLines cmd = (WriteLines)command;
        EclFile out = FileResolver.resolve((String)cmd.getUri());
        PrintStream ps = null;
        try {
            try {
                Writer fileWriter = Util.getWriter((EclFile)out, (boolean)cmd.isAppend());
                BufferedWriter writer = new BufferedWriter(fileWriter);
                for (Object obj : CoreUtils.readPipeContent((IPipe)context.getInput())) {
                    writer.write("" + BoxedValues.unbox(obj));
                    writer.newLine();
                }
                writer.close();
            }
            catch (IOException e) {
                throw new CoreException(EclDataPlugin.createErr(e, "Cannot write to %s", out.toURI()));
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return Status.OK_STATUS;
    }
}

