/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.debug.core;

import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.debug.core.DebuggerCallback;
import org.eclipse.rcptt.ecl.debug.core.DebuggerTransport;
import org.eclipse.rcptt.ecl.debug.runtime.Session;
import org.eclipse.rcptt.ecl.internal.debug.core.Plugin;

public class DebuggerBaseTransport
implements DebuggerTransport {
    private volatile DebuggerCallback callback;
    private Session session;

    public synchronized void create(int port, String host) throws CoreException {
        try {
            Socket socket = new Socket(host, port);
            this.session = new Session(socket){

                protected void handle(EObject event) {
                    DebuggerCallback c = DebuggerBaseTransport.this.callback;
                    if (c != null) {
                        DebuggerBaseTransport.this.callback.handleResponse(event);
                    }
                }

                protected void handle(Exception e) {
                    Plugin.log(e);
                }
            };
        }
        catch (Exception e) {
            throw new CoreException(Plugin.status("Couldn't connect to debugger", e));
        }
    }

    @Override
    public synchronized void request(EObject event) throws CoreException {
        this.session.request(event);
    }

    @Override
    public synchronized void setCallback(DebuggerCallback callback) {
        this.callback = callback;
    }

    public void terminate() {
        if (this.session != null) {
            this.session.terminate();
        }
    }
}

