/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameDialog
extends Dialog {
    private Text nameText;
    private String oldName;
    private Text fileName;
    private Set<String> scenarious;
    private IFile file;
    private String resultName;
    private String resultFileName;
    private String dialogName;
    private Set<IPath> fileSkip;
    private String newNameProposal;

    public RenameDialog(Shell parentShell, String oldName, Set<String> scenarios, IFile file, String dialogName, Set<IPath> filesSkip, String newNameProposal) {
        super(parentShell);
        this.dialogName = dialogName;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.scenarious = scenarios;
        this.file = file;
        this.fileSkip = filesSkip;
        this.oldName = oldName;
        if (oldName == null) {
            oldName = "";
        }
        this.newNameProposal = newNameProposal;
    }

    private String convert(String text) {
        StringBuilder result = new StringBuilder();
        String invalidChars = Platform.getOS().equals("win32") ? "\\/:*?\"<>|" : (Platform.getOS().equals("macosx") ? "/:" : "/");
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (invalidChars.contains("" + c)) {
                result.append("_");
            } else {
                result.append(c);
            }
            ++n2;
        }
        result.append("." + this.file.getFileExtension());
        return result.toString();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Label label = new Label(composite, 16384);
        label.setText(Messages.RenameDialog_NewNameLabel);
        this.nameText = new Text(composite, 2048);
        GridData data = new GridData(768);
        this.nameText.setLayoutData((Object)data);
        Label fName = new Label(composite, 16384);
        fName.setText(Messages.RenameDialog_FileNameLabel);
        this.fileName = new Text(composite, 2056);
        this.fileName.setEnabled(false);
        GridDataFactory.fillDefaults().applyTo((Control)this.fileName);
        if (this.newNameProposal != null) {
            int index = 0;
            do {
                String pt = index == 0 ? "" : "(" + Integer.valueOf(index) + ")";
                this.nameText.setText(String.valueOf(this.newNameProposal) + " " + this.oldName + pt);
                this.fileName.setText(this.convert(this.nameText.getText()));
                ++index;
            } while (!this.isValid());
        } else {
            this.nameText.setText(this.oldName);
        }
        this.fileName.setText(this.convert(this.nameText.getText()));
        this.nameText.selectAll();
        this.nameText.forceFocus();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameDialog.this.fileName.setText(RenameDialog.this.convert(RenameDialog.this.nameText.getText()));
                RenameDialog.this.validate();
            }
        });
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validate();
        return result;
    }

    private void validate() {
        this.getButton(0).setEnabled(this.isValid());
    }

    private boolean isValid() {
        String text = this.nameText.getText();
        if (text == null || text.length() == 0) {
            return false;
        }
        if (this.scenarious.contains(text)) {
            return false;
        }
        IPath newFileName = this.file.getFullPath().removeLastSegments(1).append(this.fileName.getText());
        if (this.fileSkip != null && this.fileSkip.contains(newFileName)) {
            return false;
        }
        if (this.file.getParent().getFile((IPath)new Path(this.fileName.getText())).exists()) {
            return false;
        }
        return !text.equals(this.oldName);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogName);
    }

    protected Point getInitialSize() {
        return new Point(400, 180);
    }

    protected void okPressed() {
        this.resultName = this.nameText.getText();
        this.resultFileName = this.fileName.getText();
        super.okPressed();
    }

    public String getResultName() {
        return this.resultName;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public IPath getNewFileName() {
        return this.file.getFullPath().removeLastSegments(1).append(this.resultFileName);
    }
}

