/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class AssumeUnchangedOperation
implements IEGitOperation {
    private final Collection<? extends IResource> rsrcList;
    private final Collection<IPath> locations;
    private Repository db;
    private final IdentityHashMap<Repository, DirCache> caches;
    private final boolean assumeUnchanged;

    public AssumeUnchangedOperation(Collection<? extends IResource> rsrcs, boolean assumeUnchanged) {
        this.rsrcList = rsrcs;
        this.locations = Collections.emptyList();
        this.caches = new IdentityHashMap();
        this.assumeUnchanged = assumeUnchanged;
    }

    public AssumeUnchangedOperation(Repository repository, Collection<IPath> locations, boolean assumeUnchanged) {
        this.db = repository;
        this.locations = locations;
        this.rsrcList = Collections.emptyList();
        this.caches = new IdentityHashMap();
        this.assumeUnchanged = assumeUnchanged;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((this.rsrcList.size() + this.locations.size()) * 2));
        progress.setTaskName(CoreText.AssumeUnchangedOperation_adding);
        this.caches.clear();
        try {
            try {
                for (IResource resource : this.rsrcList) {
                    this.assumeValid(resource);
                    progress.worked(1);
                }
                for (IPath location : this.locations) {
                    this.assumeValid(location);
                    progress.worked(1);
                }
                progress.setWorkRemaining(this.caches.size());
                for (Map.Entry e : this.caches.entrySet()) {
                    db = (Repository)e.getKey();
                    editor = (DirCache)e.getValue();
                    progress.setTaskName(NLS.bind((String)CoreText.AssumeUnchangedOperation_writingIndex, (Object)db.getDirectory()));
                    editor.write();
                    editor.commit();
                    progress.worked(1);
                }
            }
            catch (RuntimeException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
            catch (IOException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
        }
        finally {
            ** for (cache : this.caches.values())
        }
lbl-1000:
        // 1 sources

        {
            cache.unlock();
            continue;
        }
lbl34:
        // 1 sources

        this.caches.clear();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.rsrcList.toArray(new IResource[this.rsrcList.size()]));
    }

    private void assumeValid(IResource resource) throws CoreException {
        IProject proj = resource.getProject();
        if (proj == null) {
            return;
        }
        GitProjectData pd = GitProjectData.get(proj);
        if (pd == null) {
            return;
        }
        RepositoryMapping rm = pd.getRepositoryMapping(resource);
        if (rm == null) {
            return;
        }
        this.db = rm.getRepository();
        this.assumeValid(resource.getLocation());
    }

    private void assumeValid(IPath location) throws CoreException {
        DirCache cache = this.caches.get(this.db);
        if (cache == null) {
            try {
                cache = this.db.lockDirCache();
            }
            catch (IOException err) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, err));
            }
            this.caches.put(this.db, cache);
        }
        Path dbDir = new Path(this.db.getWorkTree().getAbsolutePath());
        String path = location.makeRelativeTo((IPath)dbDir).toString();
        if (location.toFile().isDirectory()) {
            DirCacheEntry[] dirCacheEntryArray = cache.getEntriesWithin(path);
            int n = dirCacheEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirCacheEntry ent = dirCacheEntryArray[n2];
                ent.setAssumeValid(this.assumeUnchanged);
                ++n2;
            }
        } else {
            DirCacheEntry ent = cache.getEntry(path);
            if (ent != null) {
                ent.setAssumeValid(this.assumeUnchanged);
            }
        }
    }
}

