/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.AbstractPartSelectionTracker;

public class WindowPartSelectionTracker
extends AbstractPartSelectionTracker
implements IPageListener {
    private IWorkbenchWindow fWindow;
    private final INullSelectionListener selListener = (part, selection) -> this.fireSelection(part, selection);
    private final INullSelectionListener postSelListener = (part, selection) -> this.firePostSelection(part, selection);

    public WindowPartSelectionTracker(IWorkbenchWindow window, String partId) {
        super(partId);
        this.setWindow(window);
        window.addPageListener(this);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.pageOpened(page);
            ++n2;
        }
    }

    @Override
    public void pageActivated(IWorkbenchPage page) {
    }

    @Override
    public void pageClosed(IWorkbenchPage page) {
        page.removeSelectionListener(this.getPartId(), this.selListener);
        page.removePostSelectionListener(this.getPartId(), this.postSelListener);
    }

    @Override
    public void pageOpened(IWorkbenchPage page) {
        page.addSelectionListener(this.getPartId(), this.selListener);
        page.addPostSelectionListener(this.getPartId(), this.postSelListener);
    }

    private void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fWindow = null;
    }

    @Override
    public ISelection getSelection() {
        IWorkbenchPage page = this.getWindow().getActivePage();
        if (page != null) {
            return page.getSelection(this.getPartId());
        }
        return null;
    }
}

