/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.Messages;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.target.ExternalFileTargetHandle;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;

public class ApiModelFactory {
    private static final String CVS_FOLDER_NAME = "CVS";
    public static final IApiComponent[] NO_COMPONENTS = new IApiComponent[0];
    private static final String TARGET_PREFIX = "target:";
    private static CVSNameFilter fgCvsFilter = new CVSNameFilter();
    private static long fNextId = 0L;

    private static long getBundleID() {
        return fNextId++;
    }

    public static IApiComponent newApiComponent(IApiBaseline baseline, String location) throws CoreException {
        BundleComponent component = new BundleComponent(baseline, location, ApiModelFactory.getBundleID());
        if (component.isValidBundle()) {
            return component;
        }
        return null;
    }

    public static IApiComponent newApiComponent(IApiBaseline baseline, IPluginModelBase model) throws CoreException {
        BundleDescription bundleDescription = model.getBundleDescription();
        if (bundleDescription == null) {
            return null;
        }
        String location = bundleDescription.getLocation();
        if (location == null) {
            return null;
        }
        BundleComponent component = null;
        component = ApiModelFactory.isBinaryProject(location) ? new BundleComponent(baseline, location, ApiModelFactory.getBundleID()) : new ProjectComponent(baseline, location, model, ApiModelFactory.getBundleID());
        if (component.isValidBundle()) {
            return component;
        }
        return null;
    }

    private static boolean isBinaryProject(String location) throws CoreException {
        Path path = new Path(location);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        return project != null && (!project.exists() || Util.isBinaryProject(project));
    }

    public static IApiBaseline newApiBaseline(String name) {
        return new ApiBaseline(name);
    }

    public static IApiBaseline newApiBaseline(String name, File eeDescription) throws CoreException {
        return new ApiBaseline(name, eeDescription);
    }

    public static IApiBaseline newApiBaseline(String name, String location) throws CoreException {
        return new ApiBaseline(name, null, location);
    }

    public static IApiBaseline newApiBaseline(String name, File eeDescription, String location) throws CoreException {
        return new ApiBaseline(name, eeDescription, location);
    }

    public static IApiComponent[] addComponents(IApiBaseline baseline, String installLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.configuring_baseline, (int)50);
        IApiComponent[] result = null;
        try {
            ITargetPlatformService service = null;
            ApiPlugin plugin = ApiPlugin.getDefault();
            if (plugin != null) {
                service = ApiPlugin.getDefault().acquireService(ITargetPlatformService.class);
                subMonitor.split(1);
                ITargetLocation container = service.newProfileLocation(installLocation, null);
                ITargetDefinition definition = service.newTarget();
                subMonitor.subTask(Messages.resolving_target_definition);
                container.resolve(definition, (IProgressMonitor)subMonitor.split(30));
                subMonitor.split(1);
                TargetBundle[] bundles = container.getBundles();
                ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
                if (bundles.length > 0) {
                    subMonitor.setWorkRemaining(bundles.length);
                    int i = 0;
                    while (i < bundles.length) {
                        IApiComponent component;
                        subMonitor.split(1);
                        if (!bundles[i].isSourceBundle() && (component = ApiModelFactory.newApiComponent(baseline, URIUtil.toFile((URI)bundles[i].getBundleInfo().getLocation()).getAbsolutePath())) != null) {
                            subMonitor.subTask(NLS.bind((String)Messages.adding_component__0, (Object)component.getSymbolicName()));
                            components.add(component);
                        }
                        ++i;
                    }
                }
                result = components.toArray(new IApiComponent[components.size()]);
            } else {
                File dir = new File(installLocation);
                if (dir.exists()) {
                    File[] files = dir.listFiles(fgCvsFilter);
                    if (files == null) {
                        IApiComponent[] iApiComponentArray = NO_COMPONENTS;
                        return iApiComponentArray;
                    }
                    ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File bundle = fileArray[n2];
                        IApiComponent component = ApiModelFactory.newApiComponent(baseline, bundle.getAbsolutePath());
                        if (component != null) {
                            components.add(component);
                        }
                        ++n2;
                    }
                    result = components.toArray(new IApiComponent[components.size()]);
                }
            }
            if (result != null) {
                baseline.addApiComponents(result);
                IApiComponent[] iApiComponentArray = result;
                return iApiComponentArray;
            }
            IApiComponent[] iApiComponentArray = NO_COMPONENTS;
            return iApiComponentArray;
        }
        finally {
            subMonitor.done();
        }
    }

    public static IApiBaseline newApiBaselineFromTarget(String name, ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        ApiBaseline baseline = new ApiBaseline(name);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.configuring_baseline, (int)50);
        try {
            IStatus result = definition.resolve((IProgressMonitor)subMonitor.split(30));
            if (!result.isOK()) {
                throw new CoreException(result);
            }
            subMonitor.split(1);
            TargetBundle[] bundles = definition.getBundles();
            ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
            if (bundles.length > 0) {
                subMonitor.setWorkRemaining(bundles.length);
                int i = 0;
                while (i < bundles.length) {
                    IApiComponent component;
                    subMonitor.split(1);
                    if (!bundles[i].isSourceBundle() && (component = ApiModelFactory.newApiComponent((IApiBaseline)baseline, URIUtil.toFile((URI)bundles[i].getBundleInfo().getLocation()).getAbsolutePath())) != null) {
                        subMonitor.subTask(NLS.bind((String)Messages.adding_component__0, (Object)component.getSymbolicName()));
                        components.add(component);
                    }
                    ++i;
                }
            }
            baseline.addApiComponents(components.toArray(new IApiComponent[components.size()]));
            baseline.setLocation(ApiModelFactory.generateTargetLocation(definition));
            ApiBaseline apiBaseline = baseline;
            return apiBaseline;
        }
        finally {
            subMonitor.done();
        }
    }

    private static String generateTargetLocation(ITargetDefinition definition) {
        StringBuilder sb = new StringBuilder(TARGET_PREFIX);
        sb.append('/');
        if (definition instanceof TargetDefinition) {
            sb.append(((TargetDefinition)definition).getSequenceNumber());
        }
        sb.append('/');
        sb.append(ApiModelFactory.getDefinitionIdentifier(definition));
        return sb.toString();
    }

    private static String getDefinitionIdentifier(ITargetDefinition definition) {
        String location;
        ITargetHandle targetHandle = definition.getHandle();
        if (targetHandle instanceof WorkspaceFileTargetHandle) {
            IFile file = ((WorkspaceFileTargetHandle)targetHandle).getTargetFile();
            location = file.getFullPath().toPortableString();
        } else if (targetHandle instanceof ExternalFileTargetHandle) {
            URI uri = ((ExternalFileTargetHandle)targetHandle).getLocation();
            location = uri.toASCIIString();
        } else {
            location = targetHandle.toString();
        }
        return location.replace(':', '/');
    }

    public static boolean isDerivedFromTarget(IApiBaseline profile, ITargetDefinition definition) {
        String location = profile.getLocation();
        if (location == null || !location.startsWith(TARGET_PREFIX) || location.length() <= TARGET_PREFIX.length() + 3) {
            return false;
        }
        int seqEnd = -1;
        if (location.charAt(TARGET_PREFIX.length()) != '/') {
            if ((location = location.replace(System.getProperty("file.separator"), "/")).charAt(TARGET_PREFIX.length()) != '/') {
                return false;
            }
            seqEnd = location.indexOf(47, TARGET_PREFIX.length() + 2);
            if (seqEnd == -1) {
                return false;
            }
            --seqEnd;
        }
        if (seqEnd == -1) {
            seqEnd = location.indexOf(47, TARGET_PREFIX.length() + 2);
        }
        String targetIdentifier = location.substring(seqEnd + 1);
        return targetIdentifier.equals(ApiModelFactory.getDefinitionIdentifier(definition));
    }

    public static boolean isDerivedFromTarget(IApiBaseline profile) {
        return profile.getLocation() != null && profile.getLocation().startsWith(TARGET_PREFIX);
    }

    public static boolean isUpToDateWithTarget(IApiBaseline profile, ITargetDefinition definition) {
        return profile.getLocation() != null && profile.getLocation().equals(ApiModelFactory.generateTargetLocation(definition));
    }

    static class CVSNameFilter
    implements FilenameFilter {
        CVSNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.equalsIgnoreCase(ApiModelFactory.CVS_FOLDER_NAME);
        }
    }
}

