/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.search;

import java.text.MessageFormat;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.search.RepositoryMatch;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CommitResultLabelProvider
extends WorkbenchLabelProvider {
    private int layout;
    private final IPropertyChangeListener uiPrefsListener;
    private PreferenceBasedDateFormatter dateFormatter;

    public CommitResultLabelProvider(int layout) {
        this.layout = layout;
        this.dateFormatter = PreferenceBasedDateFormatter.create();
        this.uiPrefsListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("date_format".equals(property) || "date_format_choice".equals(property)) {
                    CommitResultLabelProvider.this.dateFormatter = PreferenceBasedDateFormatter.create();
                    CommitResultLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)CommitResultLabelProvider.this));
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.uiPrefsListener);
    }

    public StyledString getStyledText(Object element) {
        StyledString styled = new StyledString();
        if (element instanceof RepositoryCommit) {
            RepositoryCommit commit = (RepositoryCommit)((Object)element);
            RevCommit revCommit = commit.getRevCommit();
            styled.append(MessageFormat.format(UIText.CommitResultLabelProvider_SectionMessage, commit.abbreviate(), revCommit.getShortMessage()));
            PersonIdent author = revCommit.getAuthorIdent();
            if (author != null) {
                styled.append(MessageFormat.format(UIText.CommitResultLabelProvider_SectionAuthor, author.getName(), this.dateFormatter.formatDate(author)), StyledString.QUALIFIER_STYLER);
            }
            if (this.layout == 1) {
                styled.append(MessageFormat.format(UIText.CommitResultLabelProvider_SectionRepository, commit.getRepositoryName()), StyledString.DECORATIONS_STYLER);
            }
        } else if (element instanceof RepositoryMatch) {
            RepositoryMatch repository = (RepositoryMatch)((Object)element);
            styled.append(repository.getLabel((Object)repository));
            styled.append(" - ", StyledString.QUALIFIER_STYLER);
            styled.append(repository.getRepository().getDirectory().getAbsolutePath(), StyledString.QUALIFIER_STYLER);
            styled.append(MessageFormat.format(" ({0})", repository.getMatchCount()), StyledString.COUNTER_STYLER);
        }
        return styled;
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.uiPrefsListener);
        super.dispose();
    }
}

