/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;

public class StringToShortConverter
extends NumberFormatConverter {
    private final NumberFormat numberFormat;
    private final boolean primitive;
    private String outOfRangeMessage;

    private StringToShortConverter(NumberFormat numberFormat, Class<?> toType) {
        super(String.class, toType, numberFormat);
        this.numberFormat = numberFormat;
        this.primitive = toType.isPrimitive();
    }

    @Override
    public Object convert(Object fromObject) {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse(fromObject, this.numberFormat, this.primitive);
        if (result.getPosition() != null) {
            throw new IllegalArgumentException(StringToNumberParser.createParseErrorMessage((String)fromObject, result.getPosition()));
        }
        if (result.getNumber() == null) {
            return null;
        }
        if (StringToNumberParser.inShortRange(result.getNumber())) {
            return result.getNumber().shortValue();
        }
        StringToShortConverter stringToShortConverter = this;
        synchronized (stringToShortConverter) {
            if (this.outOfRangeMessage == null) {
                this.outOfRangeMessage = StringToNumberParser.createOutOfRangeMessage((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, this.numberFormat);
            }
            throw new IllegalArgumentException(this.outOfRangeMessage);
        }
    }

    public static StringToShortConverter toShort(boolean primitive) {
        return StringToShortConverter.toShort(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToShortConverter toShort(NumberFormat numberFormat, boolean primitive) {
        return new StringToShortConverter(numberFormat, primitive ? Short.TYPE : Short.class);
    }
}

