/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.osgi.service.prefs.BackingStoreException;

class LinkedModeConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final String EXIT = "org.eclipse.ui.internal.workbench.texteditor.link.exit";
    private static final String TARGET = "org.eclipse.ui.internal.workbench.texteditor.link.target";
    private static final String MASTER = "org.eclipse.ui.internal.workbench.texteditor.link.master";
    private static final String SLAVE = "org.eclipse.ui.internal.workbench.texteditor.link.slave";
    static final String[] HIGHLIGHT = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_HIGHLIGHT, "unused"};
    static final String[] UNDERLINE = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_UNDERLINE, "UNDERLINE"};
    static final String[] BOX = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_BOX, "BOX"};
    static final String[] DASHED_BOX = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_DASHED_BOX, "DASHED_BOX"};
    static final String[] IBEAM = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_IBEAM, "IBEAM"};
    static final String[] SQUIGGLES = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_SQUIGGLES, "SQUIGGLES"};
    private ColorSelector fAnnotationForegroundColorEditor;
    private Button fShowInTextCheckBox;
    private StructuredViewer fAnnotationTypeViewer;
    private final ListItem[] fListModel;
    private ComboViewer fDecorationViewer;
    private FontMetrics fFontMetrics;
    protected static final int INDENT = 20;
    private OverlayPreferenceStore fStore;
    private ArrayList<SelectionListener> fMasterSlaveListeners = new ArrayList();

    private OverlayPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    public LinkedModeConfigurationBlock(OverlayPreferenceStore store) {
        this.fStore = store;
        MarkerAnnotationPreferences prefs = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys(prefs));
        this.fListModel = this.createAnnotationTypeListModel(prefs);
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        for (AnnotationPreference info : preferences.getAnnotationPreferences()) {
            if (!this.isLinkedModeAnnotation(info)) continue;
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getTextPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getTextStylePreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getHighlightPreferenceKey()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private boolean isLinkedModeAnnotation(AnnotationPreference info) {
        Object type = info.getAnnotationType();
        return type.equals(MASTER) || type.equals(SLAVE) || type.equals(TARGET) || type.equals(EXIT);
    }

    private ListItem[] createAnnotationTypeListModel(MarkerAnnotationPreferences preferences) {
        ArrayList<ListItem> listModelItems = new ArrayList<ListItem>();
        for (AnnotationPreference info : preferences.getAnnotationPreferences()) {
            if (!this.isLinkedModeAnnotation(info)) continue;
            String label = info.getPreferenceLabel();
            List<String[]> styles = this.getStyles(info.getAnnotationType());
            listModelItems.add(new ListItem(label, info.getColorPreferenceKey(), info.getTextPreferenceKey(), info.getHighlightPreferenceKey(), info.getTextStylePreferenceKey(), styles));
        }
        ListItem[] items = new ListItem[listModelItems.size()];
        listModelItems.toArray(items);
        return items;
    }

    private List<String[]> getStyles(Object type) {
        if (type.equals(MASTER)) {
            return Arrays.asList(BOX, DASHED_BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (type.equals(SLAVE)) {
            return Arrays.asList(BOX, DASHED_BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (type.equals(TARGET)) {
            return Arrays.asList(BOX, DASHED_BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (type.equals(EXIT)) {
            return Arrays.asList(new String[][]{IBEAM});
        }
        return new ArrayList<String[]>();
    }

    @Override
    public Control createControl(Composite parent) {
        OverlayPreferenceStore store = this.getPreferenceStore();
        store.load();
        store.start();
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(TextEditorMessages.LinkedModeConfigurationBlock_annotationPresentationOptions);
        GridData gd = new GridData(256);
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(4, 4, true, true);
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationTypeViewer = new TableViewer(editorComposite, 2564);
        this.fAnnotationTypeViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.fAnnotationTypeViewer.setContentProvider((IContentProvider)new ItemContentProvider());
        gd = new GridData(1, 1, false, false);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fAnnotationTypeViewer.getControl().setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setText(TextEditorMessages.LinkedModeConfigurationBlock_labels_showIn);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fDecorationViewer = new ComboViewer(optionsComposite, 8);
        this.fDecorationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fDecorationViewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        this.fDecorationViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fDecorationViewer.getControl().setLayoutData((Object)gd);
        this.fDecorationViewer.setInput((Object)new Object[]{HIGHLIGHT, SQUIGGLES, BOX, DASHED_BOX, UNDERLINE, IBEAM});
        label = new Label(optionsComposite, 16384);
        label.setText(TextEditorMessages.LinkedModeConfigurationBlock_color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorSelector(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.createDependency(this.fShowInTextCheckBox, new Control[]{label, foregroundColorButton});
        this.fAnnotationTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LinkedModeConfigurationBlock.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListItem item = LinkedModeConfigurationBlock.this.getSelectedItem();
                boolean value = LinkedModeConfigurationBlock.this.fShowInTextCheckBox.getSelection();
                if (value) {
                    String[] decoration = (String[])LinkedModeConfigurationBlock.this.fDecorationViewer.getStructuredSelection().getFirstElement();
                    if (HIGHLIGHT.equals(decoration)) {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.highlightKey, true);
                    } else {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, true);
                    }
                } else {
                    LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, false);
                    LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.highlightKey, false);
                }
                LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, value);
                LinkedModeConfigurationBlock.this.updateDecorationViewer(item, false);
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListItem item = LinkedModeConfigurationBlock.this.getSelectedItem();
                PreferenceConverter.setValue((IPreferenceStore)LinkedModeConfigurationBlock.this.getPreferenceStore(), (String)item.colorKey, (RGB)LinkedModeConfigurationBlock.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        this.fDecorationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String[] decoration = (String[])LinkedModeConfigurationBlock.this.fDecorationViewer.getStructuredSelection().getFirstElement();
                ListItem item = LinkedModeConfigurationBlock.this.getSelectedItem();
                if (LinkedModeConfigurationBlock.this.fShowInTextCheckBox.getSelection()) {
                    if (HIGHLIGHT.equals(decoration)) {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.highlightKey, true);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, false);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textStyleKey, "NONE");
                    } else {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.highlightKey, false);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, true);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textStyleKey, decoration[1]);
                    }
                }
            }
        });
        return composite;
    }

    @Override
    public void applyData(Object data) {
    }

    protected int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    protected int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    protected void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void handleAnnotationListSelection() {
        ListItem item = this.getSelectedItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.colorKey);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        boolean highlight = item.highlightKey == null ? false : this.getPreferenceStore().getBoolean(item.highlightKey);
        boolean showInText = item.textKey == null ? false : this.getPreferenceStore().getBoolean(item.textKey);
        this.fShowInTextCheckBox.setSelection(showInText || highlight);
        this.updateDecorationViewer(item, true);
    }

    @Override
    public void initialize() {
        this.initializeFields();
        this.fAnnotationTypeViewer.setInput((Object)this.fListModel);
        this.fAnnotationTypeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LinkedModeConfigurationBlock.this.fAnnotationTypeViewer != null && !LinkedModeConfigurationBlock.this.fAnnotationTypeViewer.getControl().isDisposed()) {
                    LinkedModeConfigurationBlock.this.fAnnotationTypeViewer.setSelection((ISelection)new StructuredSelection((Object)LinkedModeConfigurationBlock.this.fListModel[0]));
                    LinkedModeConfigurationBlock.this.initializeFields();
                }
            }
        });
    }

    private ListItem getSelectedItem() {
        return (ListItem)this.fAnnotationTypeViewer.getStructuredSelection().getFirstElement();
    }

    private void updateDecorationViewer(ListItem item, boolean changed) {
        boolean enabled = this.fShowInTextCheckBox.getSelection() && (item.highlightKey != null || item.textStyleKey != null);
        this.fDecorationViewer.getControl().setEnabled(enabled);
        if (changed) {
            String[] selection = null;
            ArrayList<String[]> list = new ArrayList<String[]>();
            list.addAll(item.validStyles);
            if (this.getPreferenceStore().getBoolean(item.highlightKey)) {
                selection = HIGHLIGHT;
            }
            if (selection == null) {
                String val = this.getPreferenceStore().getString(item.textStyleKey);
                for (String[] elem : list) {
                    if (!elem[1].equals(val)) continue;
                    selection = elem;
                    break;
                }
            }
            this.fDecorationViewer.setInput((Object)list.toArray(new Object[list.size()]));
            if (selection == null) {
                selection = (String[])list.get(0);
            }
            this.fDecorationViewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
        }
    }

    @Override
    public void performOk() {
        this.getPreferenceStore().propagate();
        try {
            Platform.getPreferencesService().getRootNode().node("instance").node("org.eclipse.ui.editors").flush();
        }
        catch (BackingStoreException e) {
            EditorsPlugin.log(e);
        }
    }

    @Override
    public void performDefaults() {
        this.getPreferenceStore().loadDefaults();
        this.handleAnnotationListSelection();
        this.initializeFields();
    }

    @Override
    public void dispose() {
        OverlayPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            store.stop();
        }
    }

    protected void createDependency(Button master, Control slave) {
        this.createDependency(master, new Control[]{slave});
    }

    protected void createDependency(final Button master, final Control[] slaves) {
        Assert.isTrue((slaves.length > 0 ? 1 : 0) != 0);
        LinkedModeConfigurationBlock.indent(slaves[0]);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = master.getSelection();
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(state);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    protected static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    private void initializeFields() {
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
    }

    @Override
    public boolean canPerformOk() {
        return true;
    }

    private static class ArrayLabelProvider
    extends LabelProvider {
        private ArrayLabelProvider() {
        }

        public String getText(Object element) {
            return ((String[])element)[0].toString();
        }
    }

    private static final class ItemContentProvider
    implements IStructuredContentProvider {
        private ItemContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (ListItem[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ItemLabelProvider
    extends LabelProvider {
        private ItemLabelProvider() {
        }

        public String getText(Object element) {
            return ((ListItem)element).label;
        }
    }

    private static final class ListItem {
        final String label;
        final String colorKey;
        final String highlightKey;
        final String textStyleKey;
        final String textKey;
        final List<String[]> validStyles;

        ListItem(String label, String colorKey, String textKey, String highlightKey, String textStyleKey, List<String[]> validStyles) {
            this.label = label;
            this.colorKey = colorKey;
            this.highlightKey = highlightKey;
            this.textKey = textKey;
            this.textStyleKey = textStyleKey;
            this.validStyles = validStyles;
        }
    }
}

