/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt.peg;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.tesla.core.protocol.DragKind;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.MouseEventKind;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolPackage;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectData;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramPackage;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawPackage;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.CommandPredicate;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.CommandTypePredicate;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.CommandsPredicate;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.FeaturePredicate;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.FeaturesEqPredicate;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.ProcessingRule;
import org.eclipse.rcptt.util.Predicate;
import org.eclipse.rcptt.util.Predicates;

public abstract class MatcherProcessingRule
extends ProcessingRule {
    private final Predicate<List<Command>> matcher;
    protected static FeaturesEqPredicate sameSelectData = MatcherProcessingRule.eq(new EStructuralFeature[]{ProtocolPackage.Literals.SELECT_COMMAND__DATA});
    protected static FeaturesEqPredicate isSameCellInGetItem = MatcherProcessingRule.eq(new EStructuralFeature[]{ProtocolPackage.Literals.SELECT_COMMAND__DATA});
    protected static FeaturesEqPredicate sameParentInGetItem = MatcherProcessingRule.eq(new EStructuralFeature[]{ProtocolPackage.Literals.SELECT_COMMAND__DATA, ProtocolPackage.Literals.SELECT_DATA__PARENT});
    protected static Predicate<Command> isGetItem = Predicates.and((Predicate[])new Predicate[]{MatcherProcessingRule.type(ProtocolPackage.Literals.SELECT_COMMAND), MatcherProcessingRule.field("Item", new EStructuralFeature[]{ProtocolPackage.Literals.SELECT_COMMAND__DATA, ProtocolPackage.Literals.SELECT_DATA__KIND})});
    protected static Predicate<Command> isMouseDown = Predicates.and((Predicate[])new Predicate[]{MatcherProcessingRule.type(ProtocolPackage.Literals.MOUSE_EVENT), MatcherProcessingRule.field(MouseEventKind.DOWN, new EStructuralFeature[]{ProtocolPackage.Literals.MOUSE_EVENT__KIND})});
    protected static Predicate<Command> isMouseUp = Predicates.and((Predicate[])new Predicate[]{MatcherProcessingRule.type(ProtocolPackage.Literals.MOUSE_EVENT), MatcherProcessingRule.field(MouseEventKind.UP, new EStructuralFeature[]{ProtocolPackage.Literals.MOUSE_EVENT__KIND})});
    protected static Predicate<Command> isDragStart = Predicates.and((Predicate[])new Predicate[]{MatcherProcessingRule.type(ProtocolPackage.Literals.DRAG_COMMAND), MatcherProcessingRule.field(DragKind.START, new EStructuralFeature[]{ProtocolPackage.Literals.DRAG_COMMAND__KIND})});
    protected static Predicate<Command> isSetFocus = MatcherProcessingRule.type(ProtocolPackage.Literals.SET_FOCUS);
    protected static Predicate<Command> isDefaultButton = Predicates.and((Predicate[])new Predicate[]{MatcherProcessingRule.type(ProtocolPackage.Literals.MOUSE_EVENT), MatcherProcessingRule.field(1, new EStructuralFeature[]{ProtocolPackage.Literals.MOUSE_EVENT__BUTTON})});
    protected static Predicate<Command> isEmptyStateMask = MatcherProcessingRule.field(0, new EStructuralFeature[]{ProtocolPackage.Literals.MOUSE_EVENT__STATE_MASK});
    protected static Predicate<Command> isSetTreeOrTableSelection = Predicates.and((Predicate[])new Predicate[]{MatcherProcessingRule.type(ProtocolPackage.Literals.SET_SELECTION), Predicates.or((Predicate[])new Predicate[]{MatcherProcessingRule.field("Tree", new EStructuralFeature[]{ProtocolPackage.Literals.ELEMENT_COMMAND__ELEMENT, RawPackage.Literals.ELEMENT__KIND}), MatcherProcessingRule.field("Table", new EStructuralFeature[]{ProtocolPackage.Literals.ELEMENT_COMMAND__ELEMENT, RawPackage.Literals.ELEMENT__KIND})})});
    protected static Predicate<Command> isSetText = MatcherProcessingRule.type(ProtocolPackage.Literals.SET_TEXT);
    protected static Predicate<List<Command>> isSameElement = Predicates.and((Predicate[])new Predicate[]{MatcherProcessingRule.eq(new EStructuralFeature[]{ProtocolPackage.Literals.ELEMENT_COMMAND__ELEMENT, RawPackage.Literals.ELEMENT__ID}), MatcherProcessingRule.eq(new EStructuralFeature[]{ProtocolPackage.Literals.ELEMENT_COMMAND__ELEMENT, RawPackage.Literals.ELEMENT__KIND})});
    protected static Predicate<Command> isClickText = MatcherProcessingRule.type(ProtocolPackage.Literals.CLICK_TEXT);
    protected static Predicate<Command> isSetTextOffset = MatcherProcessingRule.type(ProtocolPackage.Literals.SET_TEXT_OFFSET);
    protected static FeaturesEqPredicate isSameOffsetOffset = MatcherProcessingRule.eq(new EStructuralFeature[]{ProtocolPackage.Literals.SET_TEXT_OFFSET__OFFSET});
    protected static FeaturesEqPredicate isSameOffsetLine = MatcherProcessingRule.eq(new EStructuralFeature[]{ProtocolPackage.Literals.SET_TEXT_OFFSET__LINE});
    protected static Predicate<Command> isFigureMouseMoveNoButtons = Predicates.and((Predicate[])new Predicate[]{MatcherProcessingRule.type(DiagramPackage.Literals.FIGURE_MOUSE_COMMAND), MatcherProcessingRule.field(MouseCommandKind.MOVE, new EStructuralFeature[]{DiagramPackage.Literals.FIGURE_MOUSE_COMMAND__KIND}), MatcherProcessingRule.field(0, new EStructuralFeature[]{DiagramPackage.Literals.FIGURE_MOUSE_COMMAND__BUTTON})});
    private static List<String> editPartPathFirst = Arrays.asList("editpart", "editpart.feature");
    protected static Predicate<Command> isSelectEditPart = new Predicate<Command>(){

        public boolean apply(Command input) {
            if (!(input instanceof SelectCommand)) {
                return false;
            }
            SelectData data = ((SelectCommand)input).getData();
            return ElementKind.DiagramFigure.name().equals(data.getKind()) && data.getPath().size() > 0 && editPartPathFirst.contains(data.getPath().get(0));
        }
    };

    public MatcherProcessingRule(Predicate<List<Command>> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(List<Command> commands) {
        return this.matcher.apply(commands);
    }

    protected static CommandPredicate command(int index, Predicate<Command> ... predicates) {
        return new CommandPredicate(index, (Predicate<Command>)Predicates.and(predicates));
    }

    protected static CommandsPredicate commands(int index1, int index2, Predicate<List<Command>> ... predicates) {
        return new CommandsPredicate(new int[]{index1, index2}, (Predicate<List<Command>>)Predicates.and(predicates));
    }

    protected static FeaturesEqPredicate eq(EStructuralFeature ... features) {
        return new FeaturesEqPredicate(features);
    }

    protected static CommandTypePredicate type(EClass type) {
        return new CommandTypePredicate(type);
    }

    protected static FeaturePredicate field(Object expected, EStructuralFeature ... features) {
        return new FeaturePredicate(expected, features);
    }
}

