/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.reflection;

import org.eclipse.rcptt.tesla.core.ui.PropertyNodeType;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.swt.reflection.SWTStyleConstantsData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Widget;

public class MemberValueHelper {
    static PropertyNodeType detectType(Class<?> nativeType) {
        if (nativeType.isPrimitive() || nativeType.equals(Boolean.class) || nativeType.equals(Character.class) || nativeType.equals(Byte.class) || nativeType.equals(Short.class) || nativeType.equals(Integer.class) || nativeType.equals(Long.class) || nativeType.equals(Float.class) || nativeType.equals(Double.class) || nativeType.equals(String.class) || nativeType.equals(StringBuilder.class) || nativeType.equals(StringBuffer.class) || nativeType.equals(Color.class)) {
            return PropertyNodeType.PROPERTY;
        }
        return PropertyNodeType.REFERENCE;
    }

    static String getFormattedValue(Object value, String memberName, Class<?> nativeType, Object container) {
        if (value == null) {
            if (PropertyNodeType.PROPERTY.equals((Object)MemberValueHelper.detectType(nativeType))) {
                return "";
            }
            return "null";
        }
        if (nativeType.equals(Color.class)) {
            Color color = (Color)value;
            return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        }
        if (memberName.equals("getStyle") && container instanceof Widget && (nativeType.equals(Integer.TYPE) || nativeType.equals(Integer.class))) {
            int style = (Integer)value;
            int processedStyle = 0;
            String strStyle = "";
            for (SWTStyleConstantsData.StyleConstant styleConst : SWTStyleConstantsData.styleConstants) {
                for (Class<?> clazz : styleConst.getApplyedTo()) {
                    if (!clazz.isAssignableFrom(container.getClass()) || (style & styleConst.getValue()) == 0) continue;
                    strStyle = String.valueOf(strStyle) + (strStyle.equals("") ? styleConst.getName() : ", " + styleConst.getName());
                    processedStyle |= styleConst.getValue();
                    break;
                }
                if (style == processedStyle) break;
            }
            if (style == processedStyle) {
                return "[" + strStyle + "]";
            }
        }
        String result = PlayerTextUtils.replaceMultilines(value.toString());
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < result.length()) {
            char charAt = result.charAt(i);
            if (Character.isISOControl(charAt) && charAt != '\n') {
                builder.append("\\").append((Object)charAt);
            } else {
                builder.append(charAt);
            }
            ++i;
        }
        return builder.toString();
    }

    static String getClassName(Object object) {
        if (object.getClass().isArray()) {
            return String.valueOf(object.getClass().getComponentType().getName()) + "[]";
        }
        return object.getClass().getName();
    }
}

