/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.events;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class RcpttMouseEvents {
    public static final int MouseEnter = 6;
    public static final int MouseExit = 7;
    private static Point cursor;
    private static Widget underMouse;

    public static synchronized void updateWidgetUnderMouse() {
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay == null) {
            return;
        }
        Point newCursor = currentDisplay.getCursorLocation();
        if (newCursor == null) {
            RcpttMouseEvents.setCursor(null);
            RcpttMouseEvents.notifyMouseExit();
        } else {
            if (newCursor.equals((Object)cursor)) {
                return;
            }
            RcpttMouseEvents.setCursor(newCursor);
        }
        Shell activeShell = currentDisplay.getActiveShell();
        if (activeShell == null) {
            return;
        }
        Point p = activeShell.toControl(cursor);
        WidgetInfo newUnderMouse = RcpttMouseEvents.getChild((Widget)activeShell, p.x, p.y, true);
        if (newUnderMouse == null || newUnderMouse.widget == null) {
            RcpttMouseEvents.notifyMouseExit();
        } else {
            if (newUnderMouse.widget.equals(underMouse) && !(underMouse instanceof ToolBar)) {
                return;
            }
            RcpttMouseEvents.notifyMouseExit();
            underMouse = newUnderMouse.widget;
            RcpttMouseEvents.notifyMouseEnter(newUnderMouse.x, newUnderMouse.y);
        }
    }

    public static void reset() {
        underMouse = null;
        cursor = null;
    }

    private static void setCursor(Point newCursor) {
        cursor = newCursor;
    }

    private static void notifyMouseExit() {
        if (underMouse != null && !underMouse.isDisposed()) {
            underMouse.notifyListeners(6, new Event());
        }
        underMouse = null;
    }

    private static void notifyMouseEnter(int x, int y) {
        if (!underMouse.isDisposed()) {
            Event event = new Event();
            event.x = x;
            event.y = y;
            underMouse.notifyListeners(6, event);
        } else {
            underMouse = null;
        }
    }

    private static WidgetInfo getChild(Widget parent, int x, int y, boolean root) {
        int relY;
        if (!(parent instanceof Control)) {
            return RcpttMouseEvents.info(parent);
        }
        Control control = (Control)parent;
        int relX = root ? x : x - control.getBounds().x;
        int n = relY = root ? y : y - control.getBounds().y;
        if (!(parent instanceof Composite)) {
            return RcpttMouseEvents.info(parent);
        }
        Composite c = (Composite)parent;
        if (c instanceof Tree) {
            return RcpttMouseEvents.info((Widget)((Tree)c).getItem(new Point(relX, relY)), relX, relY);
        }
        if (c instanceof Table) {
            return RcpttMouseEvents.info((Widget)((Table)c).getItem(new Point(relX, relY)), relX, relY);
        }
        if (c instanceof ToolBar) {
            return RcpttMouseEvents.info((Widget)((ToolBar)c).getItem(new Point(relX, relY)));
        }
        Control[] controlArray = c.getChildren();
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Control ctrl = controlArray[n3];
            if (ctrl.getBounds().contains(relX, relY) && ctrl.isVisible()) {
                return RcpttMouseEvents.getChild((Widget)ctrl, relX, relY, false);
            }
            ++n3;
        }
        return RcpttMouseEvents.info(parent);
    }

    private static WidgetInfo info(Widget w, int x, int y) {
        return new WidgetInfo(w, x, y);
    }

    private static WidgetInfo info(Widget w) {
        if (w instanceof Control) {
            Rectangle b = ((Control)w).getBounds();
            return new WidgetInfo(w, b.x, b.y);
        }
        return new WidgetInfo(w);
    }

    private static class WidgetInfo {
        public final Widget widget;
        public final int x;
        public final int y;

        public WidgetInfo(Widget w) {
            this(w, 0, 0);
        }

        public WidgetInfo(Widget w, int x, int y) {
            this.widget = w;
            this.x = x;
            this.y = y;
        }
    }
}

