/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.HashSet;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.filebuffers.manipulation.RemoveTrailingWhitespaceOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.editors.text.FileBufferOperationHandler;
import org.eclipse.ui.internal.editors.text.SelectResourcesDialog;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class RemoveTrailingWhitespaceHandler
extends FileBufferOperationHandler {
    private boolean fStrictCheckIfTextLocation = true;

    public RemoveTrailingWhitespaceHandler() {
        super((IFileBufferOperation)new RemoveTrailingWhitespaceOperation());
    }

    @Override
    protected boolean isAcceptableLocation(IPath location) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        return location != null && manager.isTextFileLocation(location, this.fStrictCheckIfTextLocation);
    }

    @Override
    protected IFile[] collectFiles(IResource[] resources) {
        IFile[] files = super.collectFiles(resources);
        files = this.filterUnacceptableFiles(files);
        if (this.containsOnlyFiles(resources)) {
            return files;
        }
        SelectResourcesDialog.IFilter filter = new SelectResourcesDialog.IFilter(){

            @Override
            public boolean accept(IResource resource) {
                return resource != null && RemoveTrailingWhitespaceHandler.this.isAcceptableLocation(resource.getFullPath());
            }
        };
        SelectResourcesDialog dialog = new SelectResourcesDialog(this.getShell(), TextEditorMessages.RemoveTrailingWhitespaceHandler_dialog_title, TextEditorMessages.RemoveTrailingWhitespaceHandler_dialog_description, filter);
        dialog.setInput(resources);
        int result = dialog.open();
        if (result == 0) {
            IResource[] selectedResources = dialog.getSelectedResources();
            return super.collectFiles(selectedResources);
        }
        return null;
    }

    private boolean containsOnlyFiles(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if ((1 & resource.getType()) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IFile[] filterUnacceptableFiles(IFile[] files) {
        HashSet<IFile> filtered = new HashSet<IFile>();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            if (this.isAcceptableLocation(file.getFullPath())) {
                filtered.add(file);
            }
            ++i;
        }
        return filtered.toArray(new IFile[filtered.size()]);
    }

    public void setEnabled(Object evaluationContext) {
        this.fStrictCheckIfTextLocation = true;
        if (evaluationContext instanceof IEvaluationContext) {
            Object selection = ((IEvaluationContext)evaluationContext).getVariable("selection");
            this.fStrictCheckIfTextLocation = !(selection instanceof ITextSelection);
        }
        super.setEnabled(evaluationContext);
    }
}

