/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface NamedResource {
    public static final Function<NamedResource, String> NAME_EXTRACTOR = input -> input == null ? null : input.getName();
    public static final Comparator<NamedResource> BY_NAME_COMPARATOR = Comparator.comparing(NAME_EXTRACTOR, String.CASE_INSENSITIVE_ORDER);

    public String getName();

    public static List<String> getNameList(Collection<? extends NamedResource> resources) {
        return GenericUtils.map(resources, NamedResource::getName);
    }

    public static String getNames(Collection<? extends NamedResource> resources) {
        List<String> nameList = NamedResource.getNameList(resources);
        return GenericUtils.join(nameList, ',');
    }

    public static <R extends NamedResource> R removeByName(String name, Comparator<? super String> c, Collection<? extends R> resources) {
        R r = NamedResource.findByName(name, c, resources);
        if (r != null) {
            resources.remove(r);
        }
        return r;
    }

    public static <R extends NamedResource> R findByName(String name, Comparator<? super String> c, Collection<? extends R> resources) {
        return (R)(GenericUtils.isEmpty(name) ? null : (NamedResource)GenericUtils.stream(resources).filter(r -> c.compare(name, r.getName()) == 0).findFirst().orElse(null));
    }
}

