/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.groups.RepositoryGroups;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.ui.navigator.CommonViewer;

public class CreateRepositoryGroupCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public static final String COMMAND_ID = "org.eclipse.egit.ui.RepositoriesCreateGroup";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryGroup group;
        RepositoryGroups groupsUtil = RepositoryGroups.getInstance();
        try {
            group = groupsUtil.createGroup(CreateRepositoryGroupCommand.newGroupName(groupsUtil));
        }
        catch (IllegalStateException e) {
            throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
        List<File> repoDirs = this.getSelectedRepositories(event);
        if (!repoDirs.isEmpty()) {
            groupsUtil.addRepositoriesToGroup(group, repoDirs);
        }
        CommonViewer viewer = this.getView(event).getCommonViewer();
        viewer.refresh();
        viewer.setSelection((ISelection)new StructuredSelection((Object)new RepositoryGroupNode(group)), true);
        ITreeSelection sel = viewer.getStructuredSelection();
        viewer.editElement(sel.getFirstElement(), 0);
        return null;
    }

    private List<File> getSelectedRepositories(ExecutionEvent event) throws ExecutionException {
        return this.getSelectedNodes(event).stream().filter(node -> node instanceof RepositoryNode).filter(node -> node.getParent() == null || node.getParent().getType() == RepositoryTreeNodeType.REPOGROUP).map(e -> e.getRepository().getDirectory()).collect(Collectors.toList());
    }

    @NonNull
    private static String newGroupName(RepositoryGroups groups) {
        int i = 1;
        while (i < 100) {
            String name = MessageFormat.format(UIText.RepositoriesView_NewGroupFormat, i);
            if (name != null && !groups.groupExists(name)) {
                return name;
            }
            ++i;
        }
        return String.valueOf(MessageFormat.format(UIText.RepositoriesView_NewGroupFormat, 1)) + ' ' + UUID.randomUUID().toString();
    }
}

