/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher.confined;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class ListenerDefinition {
    private static final String LEGACY_PLAIN = "legacy-plain";
    private static final String LEGACY_BRIEF = "legacy-brief";
    private static final String LEGACY_XML = "legacy-xml";
    private String ifProperty;
    private String unlessProperty;
    private String className;
    private String resultFile;
    private boolean sendSysOut;
    private boolean sendSysErr;
    private String outputDir;

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    String getIfProperty() {
        return this.ifProperty;
    }

    public void setIf(String ifProperty) {
        this.ifProperty = ifProperty;
    }

    String getUnlessProperty() {
        return this.unlessProperty;
    }

    public void setUnless(String unlessProperty) {
        this.unlessProperty = unlessProperty;
    }

    public void setType(ListenerType type) {
        switch (type.getValue()) {
            case "legacy-plain": {
                this.setClassName("org.apache.tools.ant.taskdefs.optional.junitlauncher.LegacyPlainResultFormatter");
                break;
            }
            case "legacy-brief": {
                this.setClassName("org.apache.tools.ant.taskdefs.optional.junitlauncher.LegacyBriefResultFormatter");
                break;
            }
            case "legacy-xml": {
                this.setClassName("org.apache.tools.ant.taskdefs.optional.junitlauncher.LegacyXmlResultFormatter");
            }
        }
    }

    public void setResultFile(String filename) {
        this.resultFile = filename;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public void setSendSysOut(boolean sendSysOut) {
        this.sendSysOut = sendSysOut;
    }

    public boolean shouldSendSysOut() {
        return this.sendSysOut;
    }

    public void setSendSysErr(boolean sendSysErr) {
        this.sendSysErr = sendSysErr;
    }

    public boolean shouldSendSysErr() {
        return this.sendSysErr;
    }

    public void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public boolean shouldUse(Project project) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)project);
        return propertyHelper.testIfCondition((Object)this.ifProperty) && propertyHelper.testUnlessCondition((Object)this.unlessProperty);
    }

    void toForkedRepresentation(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("listener");
        writer.writeAttribute("classname", this.className);
        writer.writeAttribute("sendSysErr", Boolean.toString(this.sendSysErr));
        writer.writeAttribute("sendSysOut", Boolean.toString(this.sendSysOut));
        if (this.resultFile != null) {
            writer.writeAttribute("resultFile", this.resultFile);
        }
        writer.writeEndElement();
    }

    public static ListenerDefinition fromForkedRepresentation(XMLStreamReader reader) throws XMLStreamException {
        String resultFile;
        String sendSysOut;
        reader.require(1, null, "listener");
        ListenerDefinition listenerDef = new ListenerDefinition();
        String className = ListenerDefinition.requireAttributeValue(reader, "classname");
        listenerDef.setClassName(className);
        String sendSysErr = reader.getAttributeValue(null, "sendSysErr");
        if (sendSysErr != null) {
            listenerDef.setSendSysErr(Boolean.parseBoolean(sendSysErr));
        }
        if ((sendSysOut = reader.getAttributeValue(null, "sendSysOut")) != null) {
            listenerDef.setSendSysOut(Boolean.parseBoolean(sendSysOut));
        }
        if ((resultFile = reader.getAttributeValue(null, "resultFile")) != null) {
            listenerDef.setResultFile(resultFile);
        }
        reader.nextTag();
        reader.require(2, null, "listener");
        return listenerDef;
    }

    private static String requireAttributeValue(XMLStreamReader reader, String attrName) throws XMLStreamException {
        String val = reader.getAttributeValue(null, attrName);
        if (val != null) {
            return val;
        }
        throw new XMLStreamException("Attribute " + attrName + " is missing at " + reader.getLocation());
    }

    public static class ListenerType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{ListenerDefinition.LEGACY_PLAIN, ListenerDefinition.LEGACY_BRIEF, ListenerDefinition.LEGACY_XML};
        }
    }
}

