/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDILambdaVariable;
import org.eclipse.jdt.internal.debug.eval.ast.engine.IRuntimeContext;

public class LambdaUtils {
    private static final String LAMBDA_METHOD_PREFIX = "lambda$";

    public static IVariable findLambdaFrameVariable(IRuntimeContext context, String variableName) throws DebugException {
        IJavaStackFrame stackFrame = context.getFrame();
        if (stackFrame != null) {
            List<IVariable> variables = LambdaUtils.getLambdaFrameVariables(stackFrame);
            for (IVariable variable : variables) {
                if (!variable.getName().equals(variableName)) continue;
                return variable;
            }
        }
        return null;
    }

    public static List<IVariable> getLambdaFrameVariables(IStackFrame frame) throws DebugException {
        ArrayList<IVariable> variables = new ArrayList<IVariable>();
        if (LambdaUtils.isLambdaFrame(frame)) {
            IThread thread = frame.getThread();
            List stackFrames = Stream.of(thread.getStackFrames()).dropWhile(f -> f != frame).limit(3L).collect(Collectors.toUnmodifiableList());
            for (IStackFrame stackFrame : stackFrames) {
                IVariable[] stackFrameVariables = stackFrame.getVariables();
                variables.addAll(Arrays.asList(stackFrameVariables));
                IVariable[] iVariableArray = stackFrameVariables;
                int n = stackFrameVariables.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariable frameVariable = iVariableArray[n2];
                    if (LambdaUtils.isLambdaObjectVariable(frameVariable)) {
                        variables.addAll(LambdaUtils.extractVariablesFromLambda(frameVariable));
                    }
                    ++n2;
                }
            }
        }
        return Collections.unmodifiableList(variables);
    }

    public static boolean isLambdaFrame(IStackFrame frame) throws DebugException {
        return frame instanceof IJavaStackFrame && LambdaUtils.isLambdaFrame((IJavaStackFrame)frame);
    }

    public static boolean isLambdaFrame(IJavaStackFrame frame) throws DebugException {
        return frame.isSynthetic() && frame.getName().startsWith(LAMBDA_METHOD_PREFIX);
    }

    public static boolean isLambdaField(IVariable variable) throws DebugException {
        return variable instanceof IJavaFieldVariable && ((IJavaFieldVariable)variable).getDeclaringType().getName().contains("$Lambda$");
    }

    public static boolean isLambdaMethod(Method method) {
        return method.name().startsWith(LAMBDA_METHOD_PREFIX);
    }

    private static boolean isLambdaObjectVariable(IVariable variable) {
        return variable instanceof JDILambdaVariable;
    }

    private static List<IVariable> extractVariablesFromLambda(IVariable variable) throws DebugException {
        if (variable.getValue() instanceof IJavaObject) {
            return Arrays.asList(variable.getValue().getVariables());
        }
        return Collections.emptyList();
    }
}

