/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.PDELocationUtils;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformInitializer;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.InjectionFactory;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.runner.PrintStreamMonitor;
import org.eclipse.rcptt.runner.Q7PluginValidator;
import org.eclipse.rcptt.runner.RunnerConfiguration;

public class TargetPlatformChecker {
    private final RunnerConfiguration conf;
    private ITargetPlatformHelper targetPlatform;

    public TargetPlatformChecker(RunnerConfiguration conf) {
        this.conf = conf;
    }

    public ITargetPlatformHelper getTargetPlatform() {
        return this.targetPlatform;
    }

    public void initAndCheckTargetPlatform() throws CoreException {
        if (this.conf.location == null) {
            throw new CoreException(TargetPlatformChecker.createError("AUT location is not set"));
        }
        IStatus locationStatus = PDELocationUtils.validateProductLocation((String)this.conf.location);
        if (!locationStatus.isOK()) {
            MultiStatus rv = new MultiStatus("org.eclipse.rcptt.runner", 0, "AUT location is invalid: " + this.conf.location, null);
            rv.add(locationStatus);
            throw new CoreException((IStatus)rv);
        }
        System.out.println("Initializing target platform...");
        this.initializeTargetPlatform();
        System.out.println("Target platform is valid.");
    }

    private static IStatus createError(String message) {
        return new Status(4, "org.eclipse.rcptt.runner", message, (Throwable)new RuntimeException());
    }

    private void initializeTargetPlatform() throws CoreException {
        this.targetPlatform = null;
        String location = PDELocationUtils.getProductLocation((String)this.conf.location).getAbsolutePath();
        PrintStreamMonitor outMonitor = new PrintStreamMonitor(true);
        if (this.conf.config != null) {
            this.targetPlatform = TargetPlatformManager.createTargetPlatform((String)location, (IProgressMonitor)outMonitor);
            Map versions = this.targetPlatform.getVersions();
            Q7TargetPlatformInitializer.Q7Info q7Info = Q7TargetPlatformInitializer.getInfo((ITargetPlatformHelper)this.targetPlatform, (Map)versions);
            if (!this.conf.onlySpecified) {
                InjectionConfiguration configuration;
                IMetadataRepository repository = PDEHelper.safeLoadRepository((URI)q7Info.q7, (IProgressMonitor)outMonitor);
                if (repository != null && (configuration = Q7TargetPlatformInitializer.createInjectionConfiguration((IProgressMonitor)outMonitor, (Q7TargetPlatformInitializer.Q7Info)q7Info, (Map)versions)) != null) {
                    this.conf.config.getEntries().addAll((Collection)configuration.getEntries());
                }
            } else if (q7Info.aspectj != null) {
                UpdateSite aspectsSite = InjectionFactory.eINSTANCE.createUpdateSite();
                aspectsSite.setUri(q7Info.aspectj.toString());
                this.conf.config.getEntries().add((Object)aspectsSite);
            }
            this.targetPlatform.setTargetName("AUT");
            IStatus rv = this.targetPlatform.applyInjection(this.conf.config, (IProgressMonitor)outMonitor);
            if (!rv.isOK()) {
                throw new CoreException(rv);
            }
            if (this.targetPlatform.getWeavingHook() == null) {
                throw new CoreException(RcpttPlugin.createStatus((String)"No org.eclipse.weaving hook plugin in target platform"));
            }
        } else {
            this.targetPlatform = Q7TargetPlatformManager.createTargetPlatform((String)location, (IProgressMonitor)outMonitor);
            this.targetPlatform.setTargetName("AUT");
        }
        this.targetPlatform.save();
        if (!Q7PluginValidator.validate(this.targetPlatform)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.runner", "Target platform doesn't contain RCPTT runtime injected..."));
        }
    }
}

